package com.huigou.topsun.sap.sapApplication.application.impl;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.topsun.sap.common.HttpClient;
import com.huigou.topsun.sap.common.domain.SapResult;
import com.huigou.topsun.sap.sapApplication.application.SapBankInfoApplication;
import com.huigou.topsun.util.SAPUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/04/09/15:04
 * @Description:
 */
@Service("sapBankInfoApplication")
public class SapBankInfoApplicationImpl implements SapBankInfoApplication {
    @Autowired
    private HttpClient httpClient;
    @Override
    public List<Map<String, String>> getBankInfo(String BANKS) throws IOException {
        Map<String,String> param = new HashMap<>();
        param.put("BANKS",BANKS);
        List<Map<String,String>> paramList = new ArrayList<>();
        paramList.add(param);
        String execute = null;
        List<Map<String,String>> mapList = new ArrayList<>();
        try {
            execute = httpClient.execute(paramList, "search/sch_bank_info");
            Map<String, String> map = JSONObject.parseObject(execute, Map.class);
            List<SapResult> sapResultList = JSONObject.parseArray(JSONUtil.toJsonStr(map.get("MSG")), SapResult.class);
            if (sapResultList.size()>0&&"S".equals(sapResultList.get(0).getTYPE())) {
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                mapList = objectMapper.readValue(com.huigou.util.JSONUtil.toString(map.get("RDATA")), new TypeReference<List<Map<String, String>>>() {});
            }
        } catch (IOException e) {
            throw new RuntimeException("根据银行国家代码查询银行信息出错。");
        }
        return mapList;
    }


}
