package com.huigou.topsun.sap.salesOrder.domain.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class SalesOrderItemDto implements Serializable {
    /**
     * 销售订单id
     */
    private String salesOrderId;

    /**
     * 销售单号
     */
    private String salesOrderCode;

    /**
     * 订单类型
     */
    private String salesOrderType;

    /**
     * 客户
     */
    private String salesOrderCustomer;

    /**
     * 客户单号
     */
    private String salesOrderCustomerCode;

    /**
     * 下单日期
     */
    private Date salesOrderDate;

    /**
     * 交易币别
     */
    private String salesOrderCurrency;

    /**
     * 交易倍数
     */
    private String salesOrderMultiple;

    /**
     * 款式
     */
    private String salesOrderStyle;

    /**
     * 申购/采购单号
     */
    private String salesOrderProcureCode;

    /**
     * 跟单员
     */
    private String salesOrderMerchandiser;

    /**
     * 备注
     */
    private String salesOrderRemarks;

    /**
     * 创建时间
     */
    private Date salesOrderCreateTime;

    /**
     * 创建人
     */
    private String salesOrderCreator;

    /**
     * 审批时间
     */
    private Date salesOrderApprovalTime;

    /**
     * 审核人
     */
    private String salesOrderReviewer;
    /**
     * 销售订单明细id
     */
    private String salesOrderItemId;


    /**
     * 销售项次
     */
    private String salesOrderItemNumber;

    /**
     * 产品
     */
    private String salesOrderItemProduct;

    /**
     * 客户产品编码
     */
    private String salesOrderItemProductCode;

    /**
     * 客户产品名称
     */
    private String salesOrderItemProductName;

    /**
     * 订单量
     */
    private String salesOrderItemProductOrderCount;

    /**
     * loss数
     */
    private String salesOrderItemLossCount;

    /**
     * 单位
     */
    private String salesOrderItemUnit;

    /**
     * 尺码单位
     */
    private String salesOrderItemSizeUnit;

    /**
     * 交货日期
     */
    private Date salesOrderItemDeliveryDate;

    /**
     * 指令号
     */
    private String salesOrderItemInstructionCode;

    /**
     * 型体号
     */
    private String salesOrderItemFormCode;

    /**
     * 配色号
     */
    private String salesOrderItemColorCode;

    /**
     * 产品用途
     */
    private String salesOrderItemUsage;

    /**
     * 段别
     */
    private String salesOrderItemDifference;

    /**
     * 周期
     */
    private String salesOrderItemCycle;

    /**
     * 季度
     */
    private String salesOrderItemQuarter;

    /**
     * 产地
     */
    private String salesOrderItemProducer;

    /**
     * PO号
     */
    private String salesOrderItemPoCode;

    /**
     * WIP号
     */
    private String salesOrderItemWipCode;

    /**
     * 装箱数
     */
    private String salesOrderItemPackingCount;

    /**
     * 销线
     */
    private String salesOrderItemSalesLine;

    /**
     * 产品规格
     */
    private String salesOrderItemSpecifications;

    /**
     * SK编号
     */
    private String salesOrderItemSkCode;

    /**
     * 专利号
     */
    private String salesOrderItemPatentCode;

    /**
     * 材质描述
     */
    private String salesOrderItemMaterialDescription;

    /**
     * 销售订单明细表备注
     */
    private String salesOrderItemRemarks;

    /**
     * 签收人
     */
    private String salesOrderItemSignee;

    /**
     * SHIP TO ID
     */
    private String salesOrderItemShipToId;

    /**
     * 包装方式
     */
    private String salesOrderItemPackingMethod;

    /**
     * 印刷方向
     */
    private String salesOrderItemPrintDirection;

    /**
     * 单价
     */
    private BigDecimal salesOrderItemUnitPrice;

    /**
     * 总金额
     */
    private BigDecimal salesOrderItemTotalAmount;
    /**
     * 销售订单其他信息id
     */
    private String salesOrderOtherInfoId;


    /**
     * 尺码
     */
    private String salesOrderOtherInfoSize;

    /**
     * 指令数
     */
    private String salesOrderOtherInfoInstructionCount;

    /**
     * loss数
     */
    private String salesOrderOtherInfoLossCount;

    /**
     * 销售订单其他信息备注
     */
    private String salesOrderOtherInfoRemarks;

    /**
     * 生产工单号
     */
    private String salesOrderOtherInfoManufactureCode;
}
