package com.huigou.topsun.sap.qualityInfoRecord.domain.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Auther: xin.lu
 * @Date: 2024/02/28/15:35
 * @Description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SapQualityInfoRecordItemVo implements Serializable {
    /**
     * 质量信息记录号
     */
    @JsonProperty("ZMMQINFNO")
    private String zqinfno;
    /**
     * 物料编码
     */
    @JsonProperty("MATNR")
    private String matnr;

    /**
     * 物料组
     */
    @JsonProperty("MATKL")
    private String matkl;

    /**
     * 工厂
     */
    @JsonProperty("WERK")
    private String werks;

    /**
     * 供应商
     */
    @JsonProperty("LIEFERANT")
    private String lieferant;

    /**
     * 供应商名称
     */
    @JsonProperty("ZMMVENNAME")
    private String lifnrName;

    /**
     * 合格准入验证节点1
     */
    @JsonProperty("ZMMQAVFN1")
    private String zqavfn1;

    /**
     * 节点1结论
     */
    @JsonProperty("ZVFNC1")
    private String zvfnc1;


    /**
     * 合格准入验证节点2
     */
    @JsonProperty("ZMMQAVFN2")
    private String zqavfn2;
    /**
     * 节点2结论
     */
    @JsonProperty("ZMMVFNC2")
    private String zvfnc2;

    /**
     * 合格准入验证节点3
     */
    @JsonProperty("ZMMQAVFN3")
    private String zqavfn3;
    /**
     * 节点3结论
     */
    @JsonProperty("ZMMVFNC3")
    private String zvfnc3;
    /**
     * 合格准入验证节点4
     */
    @JsonProperty("ZMMQAVFN4")
    private String zqavfn4;

    /**
     * 节点4结论
     */
    @JsonProperty("ZMMVFNC4")
    private String zvfnc4;
    /**
     * 打样单号码
     */
    @JsonProperty("ZMMSPAUFNR")
    private String zspaufnr;
    /**
     * GRSRQ
     */
    @JsonProperty("ZMMGRSRQ")
    private String grsrq;

    /**
     * GRS证书号
     */
    @JsonProperty("ZMMGRSCERTNR")
    private String grscertnr;
    /**
     * GRS证书到期日
     */
    @JsonProperty("ZMMGRSCERTDATAI")
    private String grscertdatai;
    /**
     * FSC认证要求
     */
    @JsonProperty("ZMMFSCRQ")
    private String fscrq;
    /**
     * FSC证书号
     */
    @JsonProperty("ZMMFSCCERTNR")
    private String fsccertnr;
    /**
     * FSC证书到期日
     */
    @JsonProperty("ZMMFSCCERTDATAI")
    private String fsccertdatai;
    /**
     * 合格准入状态
     */
    @JsonProperty("ZMMZQAFST")
    private String zqafst;
    /**
     * 合格有效期从
     */
    @JsonProperty("ZMMZVDATAB")
    private String zvdatab;
    /**
     * 合格有效期到
     */
    @JsonProperty("ZMMZVDATAI")
    private String zvdatai;
    /**
     * 备注文本
     */
    @JsonProperty("ZMMZTEXT")
    private String ztext;
    
    @JsonProperty("ZMMERSTELLER")
    private String ersteller;//	创建人

    @JsonProperty("ZMMERSTELLDAT")
    private String erstelldat;//	创建日期

    @JsonProperty("ZMMAENDERER")
    private String aenderer;//	最近修改人

    @JsonProperty("ZMMAENDERDAT")
    private String aenderdat;//	最近修改日期

    /**
     * 批次号
     */
    @JsonProperty("CHARG")
    private String batchNo;

    /**
     * 检验数量
     */
    @JsonProperty("LFMNG")
    private BigDecimal checkNumber;

    /**
     * 单位
     */
    @JsonProperty("LFMNE")
    private String unit;

    /**
     * 凭证年份
     */
    @JsonProperty("MJAHR")
    private String certificateYear;

    /**
     * 凭证号
     */
    @JsonProperty("MBLNR")
    private String certificateNo;

    /**
     * 凭证项次
     */
    @JsonProperty("ZEILE")
    private String certificateItem;

}
