package com.huigou.topsun.sap.qualityInfoRecord.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.*;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/02/28/15:35
 * @Description:
 */
@Table(name="sap_quality_info_record_item")
@Entity
@Data
public class SapQualityInfoRecordItem extends AbstractEntity {
    /**
     * 质量信息记录id
     */
    @Column(name = "sap_quality_info_record_id")
    private String sapQualityInfoRecordId;
    /**
     * 质量信息记录号
     */
    @Column(name = "ZQINFNO")
    private String zqinfno;
    /**
     * 物料编码
     */
    @Column(name = "MATNR")
    private String matnr;
    /**
     * 物料描述
     */
    @Column(name = "MAKTX")
    private String maktx;
    /**
     * 物料组
     */
    @Column(name = "MATKL")
    private String matkl;
    /**
     * 物料组
     */
    @Column(name = "MATKL_NAME")
    private String matklName;
    /**
     * 工厂
     */
    @Column(name = "WERKS")
    private String werks;

    /**
     * 工厂
     */
    @Column(name = "WERKS_NAME")
    private String werksName;
    /**
     * 供应商
     */
    @Column(name = "LIEFERANT")
    private String lieferant;

    /**
     * 供应商
     */
    @Column(name = "LIFNR_NAME")
    private String lifnrName;

    /**
     * 合格准入验证节点1
     */
    @Column(name = "ZQAVFN1")
    private String zqavfn1;

    /**
     * 节点1结论
     */
    @Column(name = "ZVFNC1")
    private String zvfnc1;


    /**
     * 合格准入验证节点2
     */
    @Column(name = "ZQAVFN2")
    private String zqavfn2;
    /**
     * 节点2结论
     */
    @Column(name = "ZVFNC2")
    private String zvfnc2;

    /**
     * 合格准入验证节点3
     */
    @Column(name = "ZQAVFN3")
    private String zqavfn3;
    /**
     * 节点3结论
     */
    @Column(name = "ZVFNC3")
    private String zvfnc3;
    /**
     * 合格准入验证节点4
     */
    @Column(name = "ZQAVFN4")
    private String zqavfn4;

    /**
     * 节点4结论
     */
    @Column(name = "ZVFNC4")
    private String zvfnc4;
    /**
     * 打样单号码
     */
    @Column(name = "ZSPAUFNR")
    private String zspaufnr;
    /**
     * GRSRQ
     */
    @Column(name = "GRSRQ")
    private String grsrq;

    /**
     * GRS证书号
     */
    @Column(name = "GRSCERTNR")
    private String grscertnr;
    /**
     * GRS证书到期日
     */
    @Column(name = "GRSCERTDATAI")
    private Date grscertdatai;
    /**
     * FSC认证要求
     */
    @Column(name = "FSCRQ")
    private String fscrq;
    /**
     * FSC证书号
     */
    @Column(name = "FSCCERTNR")
    private String fsccertnr;
    /**
     * FSC证书到期日
     */
    @Column(name = "FSCCERTDATAI")
    private Date fsccertdatai;
    /**
     * 合格准入状态
     */
    @Column(name = "ZQAFST")
    private String zqafst;
    /**
     * 合格有效期从
     */
    @Column(name = "ZVDATAB")
    private Date zvdatab;
    /**
     * 合格有效期到
     */
    @Column(name = "ZVDATAI")
    private Date zvdatai;
    /**
     * 备注文本
     */
    @Column(name = "ZTEXT")
    private String ztext;

    /**
     * 消息类型
     */
    @Column(name = "TYPE")
    private String type;

    /**
     * 消息文本
     */
    @Column(name = "MESSAGE")
    private String message;


}
