package com.huigou.topsun.sap.qualityInfoRecord.controller;

import com.huigou.topsun.sap.qualityInfoRecord.application.SapQualityInfoRecordItemApplication;
import com.huigou.topsun.sap.qualityInfoRecord.domain.query.SapQualityInfoRecordQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/02/28/15:40
 * @Description:
 */
@Controller
@ControllerMapping("/sapQualityInfoRecordItem")
public class SapQualityInfoRecordItemController extends CommonController {
    @Resource
    private SapQualityInfoRecordItemApplication sapQualityInfoRecordItemApplication;

    public String querySapQualityInfoRecordItems(){
        SDO sdo = this.getSDO();
        SapQualityInfoRecordQueryRequest queryRequest = sdo.toQueryRequest(SapQualityInfoRecordQueryRequest.class);
        Map<String, Object> map = sapQualityInfoRecordItemApplication.querySapQualityInfoRecordItem(queryRequest);
        return toResult(map);
    }

    public String deleteSapQualityInfoRecordItem(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        sapQualityInfoRecordItemApplication.deleteByIds(ids);
        return success();
    }
}
