package com.huigou.topsun.sap.purchaseOrder.domain.vo;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author xin.lu
 * @Description: TODO
 * @date 2025/2/2114:20
 */
@Data
public class ProductKey {
    private final String productCode;
    private final String wempf;
    private final BigDecimal kbetr;

    public ProductKey(String productCode, String wempf, BigDecimal kbetr) {
        this.productCode = productCode;
        this.wempf = wempf;
        this.kbetr = kbetr;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProductKey that = (ProductKey) o;
        return productCode.equals(that.productCode) && wempf.equals(that.wempf) && kbetr.equals(that.kbetr);
    }

    @Override
    public int hashCode() {
        return java.util.Objects.hash(productCode, wempf, kbetr);
    }
}
