package com.huigou.topsun.sap.purchaseOrder.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.nonProdApply.application.NonProdApplyApplication;
import com.huigou.topsun.sap.purchaseOrder.application.SapPurchaseOrderItemApplication;
import com.huigou.topsun.sap.purchaseOrder.domain.SapPurchaseOrderItem;
import com.huigou.topsun.sap.purchaseOrder.domain.query.SapPurchaseOrderItemQueryRequest;
import com.huigou.topsun.sap.purchaseOrder.repository.SapPurchaseOrderItemRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/01/09/19:20
 * @Description:
 */
@Service
public class SapPurchaseOrderItemApplicationImpl extends BaseApplication implements SapPurchaseOrderItemApplication {
    @Resource
    private SapPurchaseOrderItemRepository sapPurchaseOrderItemRepository;
    @Resource
    private NonProdApplyApplication nonProdApplyApplication;
    @Override
    public void saveSapPurchaseOrderItem(SapPurchaseOrderItem sapPurchaseOrderItem) {
            sapPurchaseOrderItemRepository.save(sapPurchaseOrderItem);
    }

    @Override
    public void saveSapPurchaseOrderItems(String sapPurchaseOrderId, List<SapPurchaseOrderItem> sapPurchaseOrderItems) {
        sapPurchaseOrderItems.forEach(sapPurchaseOrderItem -> {
            sapPurchaseOrderItem.setPurchaseOrderId(sapPurchaseOrderId);
        });
        sapPurchaseOrderItemRepository.save(sapPurchaseOrderItems);
    }
    

    @Override
    public List<SapPurchaseOrderItem> getPurchaseOrderItems(String purchaseOrderId) {
        return sapPurchaseOrderItemRepository.findAllByPurchaseOrderId(purchaseOrderId);
    }
    @Override
    public Map<String, Object> querySapPurchaseOrderItems(SapPurchaseOrderItemQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getSapPurchaseOrderId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "sapPurchaseOrderItems");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
            List<Map<String, Object>> mapList = (List<Map<String, Object>>) map.get("Rows");
            mapList.forEach(m->{
                String matnr = (String)m.get("matnr");
                String werks = (String)m.get("werks");
                String maktxRemZh = nonProdApplyApplication.getMaktxRemZhByMatnrAndWerks(matnr, werks);
                m.put("maktxRemZh", maktxRemZh);
            });
        }
        return map;
    }

    @Override
    public void deletePurchaseOrderItems(List<SapPurchaseOrderItem> purchaseOrderItems) {
        sapPurchaseOrderItemRepository.delete(purchaseOrderItems);
    }
}
