package com.huigou.topsun.sap.purchaseOrder.application;

import com.huigou.topsun.sap.purchaseOrder.domain.SapPurchaseOrder;
import com.huigou.topsun.sap.purchaseOrder.domain.query.SapPurchaseOrderQueryRequest;
import com.huigou.topsun.sap.purchaseOrder.domain.vo.SapPurchaseOrderDto;
import com.huigou.topsun.sap.purchaseOrder.domain.vo.SapPurchaseOrderVo;

import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/01/09/18:59
 * @Description:
 */
public interface SapPurchaseOrderApplication {
    public static final String QUERY_XML_FILE_PATH = "config/topsun/sap/sapPurchaseOrder/sapPurchaseOrder.xml";

    String PROCESS_DEFINITION_KEY = "sapPurchaseOrderProc";

    Map<String,Object> slicedSapPurchaseOrderList(SapPurchaseOrderQueryRequest queryRequest);

    SapPurchaseOrder loadSapPurchaseOrder(String id);

    void saveSapPurchaseOrderDto(SapPurchaseOrderDto sapPurchaseOrderDto);


    void sendSapDate(SapPurchaseOrder sapPurchaseOrder,String flag,String status);

    String revokeApproval(String id, String revokeReason,String revokeType);

    Map<String, Object> print(String id,Integer num);

    void updateProcessOutStatus(List<String> ids);

    void abortPurchaseOrder(String id, String jobPageId);
}
