package com.huigou.topsun.sap.purchaseInfoRecord.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huigou.data.domain.model.AbstractEntity;
import com.topsunit.query.annotations.Dictionary;
import lombok.Data;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/02/28/15:35
 * @Description:
 */
@Table(name="sap_purchase_info_record_item")
@Entity
@Data
public class SapPurchaseInfoRecordItem extends AbstractEntity {
    /**
     * 采购信息记录id
     */
    @Column(name = "sap_purchase_info_record_id")
    private String sapPurchaseInfoRecordId;
    /**
     * 采购信息记录号
     */
    @Column(name = "INFNR")
    private String infnr;
    /**
     * 采购组织
     */
    @Column(name = "EKORG")
    private String ekorg;

    /**
     * 采购组织
     */
    @Column(name = "EKORG_NAME")
    private String ekorgName;
    /**
     * 供应商
     */
    @Column(name = "LIFNR")
    private String lifnr;

    /**
     * 供应商
     */
    @Column(name = "LIFNR_NAME")
    private String lifnrName;

    /**
     * 供应商物料编码
     */
    @Column(name = "IDNLF")
    private String idnlf;
    /**
     * 名称 1
     */
    @Column(name = "NAME1")
    private String name1;
    /**
     * 物料编码
     */
    @Column(name = "MATNR")
    private String matnr;
    /**
     * 物料描述
     */
    @Column(name = "MAKTX")
    private String maktx;
    /**
     * 物料组
     */
    @Column(name = "MATKL")
    private String matkl;
    /**
     * 物料组
     */
    @Column(name = "MATKL_NAME")
    private String matklName;
    /**
     * 采购信息记录分类
     */
    @Column(name = "ESOKZ")
    private String esokz;
    /**
     * 采购组
     */
    @Column(name = "EKGRP")
    private String ekgrp;
    /**
     * 采购组
     */
    @Column(name = "EKGRP_NAME")
    private String ekgrpName;
    /**
     * 工厂
     */
    @Column(name = "WERKS")
    private String werks;

    /**
     * 工厂
     */
    @Column(name = "WERKS_NAME")
    private String werksName;
    /**
     * 生产版本
     */
    @Column(name = "VERID")
    private String verid;
    /**
     * 净价
     */
    @Column(name = "NETPR")
    private BigDecimal netpr;
    /**
     * 货币码
     */
    @Column(name = "WAERS")
    private String waers;

    @Column(name = "WAERS_NAME")
    private String waersName;
    @Column(name = "ltsnr")
    private String ltsnr;
    @Column(name = "ltsbz")
    private String ltsbz;

    /**
     * 价格单位
     */
    @Column(name = "PEINH")
    private String peinh;
    /**
     * 订单价格单位(采购)
     */
    @Column(name = "BPRME")
    private String bprme;
    /**
     * 订单价格单位(采购)
     */
    @Column(name = "BPRME_NAME")
    private String bprmeName;
    /**
     * 销售/购买税代码
     */
    @Column(name = "MWSKZ")
    private String mwskz;
    /**
     * 开始生效日期
     */
    @Column(name = "DATAB")
    private Date datab;
    /**
     * 有效期至日期
     */
    @Column(name = "DATBI")
    private Date datbi;
    /**
     * 销售员
     */
    @Column(name = "VERKF")
    private String verkf;
    /**
     * 电话
     */
    @Column(name = "TELF1")
    private String telf1;
    /**
     * 基本计量单位
     */
    @Column(name = "MEINS")
    private String meins;

    /**
     * 基本计量单位
     */
    @Column(name = "MEINS_NAME")
    private String meinsName;
    /**
     * 订单单位到基本单位转换的分母
     */
    @Column(name = "UMREN")
    private BigDecimal umren;
    /**
     * 基本计量单位转换分子
     */
    @Column(name = "UMREZ")
    private BigDecimal umrez;
    /**
     * 原产地国
     */
    @Column(name = "URZLA")
    private String urzla;

    @Column(name = "URZLA_NAME")
    private String urzlaName;

    /**
     * 地区
     */
    @Column(name = "REGIO")
    private String regio;
    /**
     * 地区
     */
    @Column(name = "REGIO_NAME")
    private String regioName;
    /**
     * 删除标志
     */
    @Column(name = "LOEKZ")
    private String loekz;
    /**
     * 排序字段
     */
    @Column(name = "SORTL")
    private String sortl;
    /**
     * 标准采购订单数量
     */
    @Column(name = "NORBM")
    private BigDecimal norbm;
    /**
     * 最小采购订单数量
     */
    @Column(name = "MINBM")
    private BigDecimal minbm;
    /**
     * 等级类型
     */
    @Column(name = "STFKZ")
    private String stfkz;
    /**
     * 计划交货时间（天）
     */
    @Column(name = "APLFZ")
    private BigDecimal aplfz;
    /**
     * 传输日期
     */
    @Column(name = "SEND_TIME")
    @Temporal(TemporalType.TIMESTAMP)
    private Date sendTime;


    /**
     * 语言
     */
    @Column(name = "ZYY")
    private String zyy;
    /**
     * 业务标识
     */
    @Column(name = "ZFLAG")
    private String zflag;
    /**
     * 基于收货的发票验证
     */
    @Column(name = "WEBRE")
    private String webre;
    /**
     * 条件类型
     */
    @Column(name = "KSCHL")
    private String kschl;
    /**
     * 价格有效至
     */
    @Column(name = "PRDAT")
    private Date prdat;
    /**
     * 订单价格单位转换为订单单位的分母
     */
    @Column(name = "BPUMN")
    private BigDecimal bpumn;
    /**
     * 订单价格单位转换为订单单位的分子
     */
    @Column(name = "BPUMZ")
    private BigDecimal bpumz;
    /**
     *条件等级计量单位
     */
    @Column(name = "KONMS")
    private String konms;
    /**
     * 等级数量1
     */
    @Column(name = "KSTBM")
    private BigDecimal kstbm;
    /**
     *等级金额1
     * */
    @Column(name = "KBETR")
    private BigDecimal kbetr;
    /**
     * 等级数量2
     */
    @Column(name = "KSTBM2")
    private BigDecimal kstbm2;

    /**
     * 等级金额2
     */
    @Column(name = "KBETR2")
    private BigDecimal kbetr2;

    /**
     * 等级数量3
     */
    @Column(name = "KSTBM3")
    private BigDecimal kstbm3;

    /**
     * 等级金额3
     */
    @Column(name = "KBETR3")
    private BigDecimal kbetr3;

    /**
     * 等级数量4
     */
    @Column(name = "KSTBM4")
    private BigDecimal kstbm4;

    /**
     * 等级金额4
     */
    @Column(name = "KBETR4")
    private BigDecimal kbetr4;


    /**
     * 等级数量5
     */
    @Column(name = "KSTBM5")
    private BigDecimal kstbm5;

    /**
     * 等级金额5
     */
    @Column(name = "KBETR5")
    private BigDecimal kbetr5;

    /**
     * 运输费
     */
    @Column(name = "FREIGHT")
    private BigDecimal freight;

    /**
     * 包装费
     */
    @Column(name = "KBETR6")
    private BigDecimal kbetr6;

    /**
     * 消息类型
     */
    @Column(name = "TYPE")
    private String TYPE;

    /**
     * 消息文本
     */
    @Column(name = "MESSAGE")
    private String MESSAGE;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    @Transient
    private String  rowId;

    /**
     * 作废标志
     */
    @Column(name = "cancel_flag")
    private String  cancelFlag;

    /**
     * 定价条件号
     */
    @Column(name = "KNUMH")
    private String knumh;


}
