package com.huigou.topsun.sap.purchaseInfoRecord.application.impl;

import com.huigou.topsun.sap.purchaseInfoRecord.domain.SapPurchaseInfoRecord;
import com.huigou.topsun.sap.purchaseInfoRecord.domain.SapPurchaseInfoRecordItem;
import com.huigou.topsun.sap.purchaseInfoRecord.domain.TmpSapPurchaseInfoRecord;
import com.huigou.topsun.sap.purchaseInfoRecord.repository.SapPurchaseInfoRecordItemRepository;
import com.huigou.topsun.sap.purchaseInfoRecord.repository.SapPurchaseInfoRecordRepository;
import com.huigou.topsun.sap.purchaseInfoRecord.repository.TmpSapPurchaseInfoRecordRepository;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.tool.dataimport.application.ExcelImportInterface;
import com.huigou.util.ClassHelper;
import org.apache.cxf.common.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author xin.lu
 * @Description: TODO
 * @date 2025/8/516:50
 */
@Service("purchaseInfoRecordDataExcelImport")
public class PurchaseInfoRecordDataExcelImport implements ExcelImportInterface {
    @Autowired
    private TmpSapPurchaseInfoRecordRepository tmpSapPurchaseInfoRecordRepository;
    @Autowired
    private SapPurchaseInfoRecordRepository purchaseInfoRecordRepository;
    @Autowired
    private SapPurchaseInfoRecordItemRepository purchaseInfoRecordItemRepository;
    @Override
    public void executeImport(String s) {
        List<TmpSapPurchaseInfoRecord> tmpSapPurchaseInfoRecordList = tmpSapPurchaseInfoRecordRepository.findByBatchNumber(s);
        if (!CollectionUtils.isEmpty(tmpSapPurchaseInfoRecordList)){
            for (TmpSapPurchaseInfoRecord tmpSapPurchaseInfoRecord : tmpSapPurchaseInfoRecordList) {
                SapPurchaseInfoRecord purchaseInfoRecord = new SapPurchaseInfoRecord();
                purchaseInfoRecord.setDefaultValues();
                purchaseInfoRecord.setId(null);
                purchaseInfoRecord.setStatusId(BizBillStatus.COMPLETED.getId());
                purchaseInfoRecord.setFlag("new");
                purchaseInfoRecordRepository.save(purchaseInfoRecord);

                //采购信息记录明细
                SapPurchaseInfoRecordItem purchaseInfoRecordItem = new SapPurchaseInfoRecordItem();
                ClassHelper.copyProperties(tmpSapPurchaseInfoRecord,purchaseInfoRecordItem);
                purchaseInfoRecordItem.setId(null);
                purchaseInfoRecordItem.setSapPurchaseInfoRecordId(purchaseInfoRecord.getId());
                purchaseInfoRecordItem.setEsokz("0");
                purchaseInfoRecordItem.setTYPE("S");
                purchaseInfoRecordItem.setMESSAGE("采购信息记录号:"+purchaseInfoRecordItem.getInfnr()+"创建成功");
                purchaseInfoRecordItemRepository.save(purchaseInfoRecordItem);
            }
        }
    }
}
