package com.huigou.topsun.sap.purchaseApproval.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.common.BillStatus;
import com.huigou.topsun.sap.common.DefaultHttpClient;
import com.huigou.topsun.sap.purchaseApproval.application.SapPurchaseApprovalApplication;
import com.huigou.topsun.sap.purchaseApproval.domain.SapPurchaseApproval;
import com.huigou.topsun.sap.purchaseApproval.domain.query.SapPurchaseApprovalQueryRequest;
import com.huigou.topsun.sap.purchaseApproval.domain.vo.SapPurchaseApprovalDto;
import com.huigou.topsun.sap.purchaseApproval.domain.vo.SapPurchaseApprovalVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.JSONUtil;
import com.huigou.util.SDO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/01/09/18:58
 * @Description:
 */
@Controller
@ControllerMapping("/sapPurchaseApproval")
public class SapPurchaseApprovalController extends CommonController {
    private final static Logger LOG = LoggerFactory.getLogger(SapPurchaseApprovalController.class);
    @Resource
    private SapPurchaseApprovalApplication sapPurchaseApprovalApplication;
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/purchaseApproval/";
    }

    @SkipAuth
    @RequestMapping( value = "/getSapPurchaseApproval")
    @ResponseBody
    public HashMap<String, Object> getSapPurchaseApproval(@RequestBody SapPurchaseApprovalDto sapPurchaseApprovalDto){
        //SDO sdo = this.getSDO();
        HashMap<String, Object> messageMap = new HashMap<>();
        messageMap.put("CODE","S");
        messageMap.put("MSG","成功");
        messageMap.put("DATA",sapPurchaseApprovalDto.getLsDeader().getBanfn());
        LOG.info("SAP采购申请审批数据=={}",JSONUtil.toString(sapPurchaseApprovalDto));
        try {
            this.sapPurchaseApprovalApplication.saveSapPurchaseApprovalVo(sapPurchaseApprovalDto);
        }catch (RuntimeException e){
            messageMap.put("CODE","E");
            messageMap.put("MSG",e.getMessage());
            messageMap.put("DATA",sapPurchaseApprovalDto.getLsDeader().getBanfn());
        }
        return messageMap;
    }

    public String forwardSapPurchaseApprovalList(){
        this.putAttribute("statusKindsList", BillStatus.getValidMap());
        this.putAttribute("loginId",this.getOperator().getPersonMemberId());
        return forward("sapPurchaseApprovalList");
    }

    public String slicedSapPurchaseApprovalList(){
        SDO sdo = this.getSDO();
        SapPurchaseApprovalQueryRequest queryRequest = sdo.toQueryRequest(SapPurchaseApprovalQueryRequest.class);
        Map<String, Object> map = sapPurchaseApprovalApplication.slicedSapPurchaseApprovalList(queryRequest);
        return toResult(map);
    }

    public String forwardSapPurchaseApprovalDetail(){
        this.putAttribute("processDefinitionKey", SapPurchaseApprovalApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        SapPurchaseApproval sapPurchase = new SapPurchaseApproval();
        sapPurchase.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        sapPurchase.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("sapPurchaseApprovalDetail",sapPurchase);
    }

    public String showSapPurchaseApprovalDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        SapPurchaseApproval sapPurchaseApproval = sapPurchaseApprovalApplication.loadSapPurchaseApproval(id);
        return forward("sapPurchaseApprovalDetail",sapPurchaseApproval);
    }

    //撤销审批
    public String revokeApproval(){
        SDO sdo = this.getSDO();
        String id=sdo.getString("id");
        String revokeReason=sdo.getString("revokeReason");
        String revokeType=sdo.getString("revokeType");
        String newId=sapPurchaseApprovalApplication.revokeApproval(id,revokeReason,revokeType);
        return success();
    }

    /**
     * 强制删除待办
     * @return
     */
    public String forceAbortPurchaseApproval(){
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        //任务ID
        String jobPageId = sdo.getString("jobPageId");
        sapPurchaseApprovalApplication.abortPurchaseApproval(id, jobPageId);
        return success();
    }

    public String showRevokeDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        this.putAttribute("id",id);
        return forward("showRevokeDetail");
    }
}
