package com.huigou.topsun.sap.purchase.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.purchase.application.SapPurchaseItemApplication;
import com.huigou.topsun.sap.purchase.domain.SapPurchaseItem;
import com.huigou.topsun.sap.purchase.domain.query.SapPurchaseItemQueryRequest;
import com.huigou.topsun.sap.purchase.repository.SapPurchaseItemRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2023/12/27/17:12
 * @Description:
 */
@Service("sapPurchaseItemApplication")
public class SapPurchaseItemApplicationImpl extends BaseApplication implements SapPurchaseItemApplication {
    @Resource
    private SapPurchaseItemRepository sapPurchaseItemRepository;

    @Override
    public void saveSapPurchaseItems(String sapPurchaseId, List<SapPurchaseItem> sapPurchaseItems) {
        sapPurchaseItems.forEach(sapPurchaseItem->{
            sapPurchaseItem.setSapPurchaseId(sapPurchaseId);
            sapPurchaseItemRepository.save(sapPurchaseItem);
        });
    }

    @Override
    public Map<String, Object> querySapPurchaseItems(SapPurchaseItemQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getSapPurchaseId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "sapPurchaseItems");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            sapPurchaseItemRepository.delete(id);
        });
    }

    @Override
    public List<SapPurchaseItem> findBySapPurchaseId(String sapPurchaseId) {
        return sapPurchaseItemRepository.findBySapPurchaseId(sapPurchaseId);
    }
}
