package com.huigou.topsun.sap.produceSupplierReview.application.impl;

import com.huigou.data.domain.model.CommonDomainConstants;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.produceSupplierReview.application.NewSupplierReviewItemApplication;
import com.huigou.topsun.sap.produceSupplierReview.domain.NewSupplierReviewItem;
import com.huigou.topsun.sap.produceSupplierReview.domain.ProduceSupplierReview;
import com.huigou.topsun.sap.produceSupplierReview.repository.ProduceSupplierReviewRepository;
import com.huigou.topsun.sap.produceSupplierReview.application.ProduceSupplierReviewApplication;
import com.huigou.topsun.sap.produceSupplierReview.domain.query.ProduceSupplierReviewQueryRequest;
import com.huigou.topsun.sap.purchase.domain.SapPurchaseItem;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.bpm.FlowBroker;
import com.huigou.util.ClassHelper;
import com.huigou.util.SDO;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/06/03/11:02
 * @Description:
 */
@Service("produceSupplierReviewApplication")
public class ProduceSupplierReviewApplicationImpl extends FlowBroker implements ProduceSupplierReviewApplication {
    @Autowired
    private ProduceSupplierReviewRepository produceSupplierReviewRepository;
    @Autowired
    private NewSupplierReviewItemApplication newSupplierReviewItemApplication;

    @Override
    protected String saveBizAndApprovalData() {
        super.saveBizAndApprovalData();
        ProduceSupplierReview produceSupplierReview = getBizEntity(ProduceSupplierReview.class);
        List<NewSupplierReviewItem> newSupplierReviewItems = getBizEntities(NewSupplierReviewItem.class, "resultList");
        if (produceSupplierReview.isNew()) {
            produceSupplierReview.setStatusId(BizBillStatus.APPLYING.getId());
        } else {
            produceSupplierReview = (ProduceSupplierReview) commonDomainService.loadAndFillinProperties(produceSupplierReview);
        }
        produceSupplierReview = produceSupplierReviewRepository.save(produceSupplierReview);
        newSupplierReviewItemApplication.saveNewSupplierReviewItems(produceSupplierReview.getId(),newSupplierReviewItems);
        return produceSupplierReview.getId();
    }

    @Override
    protected Map<String, Object> getProcessBizParams(String bizId) {
        // 返回业务数据给流程实例，
        return ClassHelper.toMap(produceSupplierReviewRepository.getOne(bizId));
    }

    /**
     * 任务完成前执行
     */
    @Override
    protected void onBeforeComplete(DelegateTask delegateTask) {
        super.onBeforeComplete(delegateTask);
        String bizId = delegateTask.getExecution().getProcessBusinessKey();
        updateStatus(bizId, BizBillStatus.APPROVING);
    }

    @Transactional
    protected void updateStatus(String bizId, BizBillStatus status) {
        Assert.hasText(bizId, CommonDomainConstants.ID_NOT_BLANK);
        this.commonDomainService.updateStatus(ProduceSupplierReview.class, bizId, status.getId());
    }

    /**
     * 流程撤销事件
     **/
    @Override
    protected void onRecallProcessInstance(DelegateExecution delegateExecution) {
        String bizId = delegateExecution.getProcessBusinessKey();
        // 修改单据状态为申请
        updateStatus(bizId, BizBillStatus.APPLYING);
    }

    /**
     * 回收事件
     **/
    @Override
    protected void onWithdraw(DelegateTask delegateTask, String destActivityId) {
        super.onWithdraw(delegateTask, destActivityId);
        String bizId = delegateTask.getExecution().getProcessBusinessKey();
        if (destActivityId.equalsIgnoreCase("apply")) {
            updateStatus(bizId, BizBillStatus.APPLYING);
        }
    }

    @Override
    protected void onEnd(DelegateExecution delegateExecution) {
        //super.onEnd(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        BizBillStatus status = approvePassed() ? BizBillStatus.COMPLETED : BizBillStatus.ABORTED;
        ProduceSupplierReview produceSupplierReview = produceSupplierReviewRepository.findOne(bizId);
        produceSupplierReview.setStatusId(status.getId());
        produceSupplierReviewRepository.save(produceSupplierReview);
    }

    @Override
    protected void onAbortProcessInstance(DelegateExecution delegateExecution) {
        super.onAbortProcessInstance(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        ProduceSupplierReview produceSupplierReview = produceSupplierReviewRepository.findOne(bizId);
        produceSupplierReview.setStatusId(BizBillStatus.ABORTED.getId());
        produceSupplierReviewRepository.save(produceSupplierReview);
    }

    /**
     * @param delegateTask
     * @param destActivityId 回退到的目标节点id
     */
    @Override
    protected void onBack(DelegateTask delegateTask, String destActivityId) {
        super.onBack(delegateTask, destActivityId);
        if ("Apply".equalsIgnoreCase(destActivityId)) {
            String bizId = delegateTask.getExecution().getProcessBusinessKey();
            ProduceSupplierReview produceSupplierReview = produceSupplierReviewRepository.findOne(bizId);
            produceSupplierReview.setStatusId(BizBillStatus.APPLYING.getId());
            produceSupplierReviewRepository.save(produceSupplierReview);
        }
    }
    @Override
    public Map<String, Object> slicedProduceSupplierReviewList(ProduceSupplierReviewQueryRequest queryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "produceSupplierReview");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
        Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        for (String id : ids) {
            produceSupplierReviewRepository.delete(id);
        }
    }

    @Override
    public ProduceSupplierReview findProduceSupplierReviewById(String id) {
        return produceSupplierReviewRepository.findOne(id);
    }

    @Override
    public Map<String, Object> slicedNewSupplierReviewItemTypeList(ProduceSupplierReviewQueryRequest queryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "newSupplierReviewItemType");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
        Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        return map;
    }

    @Override
    public Map<String, Object> slicedProduceSupplierReviewItemList(ProduceSupplierReviewQueryRequest queryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "newSupplierReviewItemList");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
        Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        return map;
    }
}
