package com.huigou.topsun.sap.processQuotedPrice.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Builder;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.ws.rs.DefaultValue;
import java.math.BigDecimal;

/**
 * @Auther: xin.lu
 * @Date: 2024/10/30/13:47
 * @Description: 工序报价明细数量区间
 */
@Data
@Entity
@Table(name = "sap_process_quoted_price_item_number")
public class ProcessQuotedPriceItemNumber extends AbstractEntity {

    @Column(name = "process_quoted_price_item_id")
    private String processQuotedPriceItemId;

    /**
     * 数量起
     */
    @Column(name = "number_from")
    private BigDecimal numberFrom;

    /**
     * 数量止
     */
    @Column(name = "number_to")
    private BigDecimal numberTo;

    /**
     * 数量区间
     */
    @Column(name = "number_section")
    private String numberSection;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 含税单价
     */
    @Column(name = "unit_price")
    private BigDecimal unitPrice;

    /**
     * 价格单位
     */
    @Column(name = "price_unit")
    private BigDecimal priceUnit;

    /**
     * 不含税单价
     */
    @Column(name = "exclude_tax_price")
    private BigDecimal excludeTaxPrice;

    /**
     * 运输费
     */
    @Column(name = "freight")
    private BigDecimal freight;

    /**
     * 最低消费
     */
    @Column(name = "minimum")
    private BigDecimal minimum;

    /**
     * LOSS数
     */
    @Column(name = "loss_number")
    private BigDecimal lossNumber;

    /**
     * 包装费
     */
    @Column(name = "pack_money")
    private BigDecimal packMoney;

    /**
     * 税码
     */
    @Column(name = "purchase_mwskz")
    private String purchaseMwskz;

}
