package com.huigou.topsun.sap.processQuotedPrice.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.common.BillStatus;
import com.huigou.topsun.sap.processQuotedPrice.application.ProcessQuotedPriceApplication;
import com.huigou.topsun.sap.processQuotedPrice.application.ProcessQuotedPriceItemNumberApplication;
import com.huigou.topsun.sap.processQuotedPrice.application.ProcessQuotedPriceItemApplication;
import com.huigou.topsun.sap.processQuotedPrice.domain.ProcessQuotedPrice;
import com.huigou.topsun.sap.processQuotedPrice.domain.ProcessQuotedPriceItemNumber;
import com.huigou.topsun.sap.processQuotedPrice.domain.query.ProcessQuotedPriceQueryRequest;
import com.huigou.topsun.sap.processQuotedPrice.domain.vo.ProcessQuotedPriceAndMwskzVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/10/30/14:09
 * @Description:
 */
@Controller
@ControllerMapping("/processQuotedPrice")
public class ProcessQuotedPriceController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/processQuotedPrice/";
    }

    @Autowired
    private ProcessQuotedPriceApplication processQuotedPriceApplication;
    @Autowired
    private ProcessQuotedPriceItemApplication processQuotedPriceItemApplication;
    @Autowired
    private ProcessQuotedPriceItemNumberApplication processQuotedPriceItemNumberApplication;

    public String forwardProcessQuotedPriceList(){
        this.putAttribute("statusKindsList", BillStatus.getValidMap());
        return forward("processQuotedPriceList");
    }

    public String slicedProcessQuotedPriceList(){
        SDO sdo = this.getSDO();
        ProcessQuotedPriceQueryRequest queryRequest = sdo.toQueryRequest(ProcessQuotedPriceQueryRequest.class);
        Map<String, Object> map = processQuotedPriceApplication.slicedProcessQuotedPriceList(queryRequest);
        return toResult(map);
    }

    public String forwardProcessQuotedPriceDetail(){
        this.putAttribute("processDefinitionKey", ProcessQuotedPriceApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        ProcessQuotedPrice processQuotedPrice = new ProcessQuotedPrice();
        processQuotedPrice.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        processQuotedPrice.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        //默认人民币
        processQuotedPrice.setCurrency("CNY");
        processQuotedPrice.setCurrencyName("人民币");
        return forward("processQuotedPriceDetail",processQuotedPrice);
    }

    public String showProcessQuotedPriceDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        ProcessQuotedPrice processQuotedPrice = processQuotedPriceApplication.loadProcessQuotedPrice(id);
        return forward("processQuotedPriceDetail",processQuotedPrice);
    }

    public String queryProcessQuotedPriceItems(){
        SDO sdo = this.getSDO();
        ProcessQuotedPriceQueryRequest queryRequest = sdo.toQueryRequest(ProcessQuotedPriceQueryRequest.class);
        Map<String, Object> map = this.processQuotedPriceItemApplication.queryProcessQuotedPriceItems(queryRequest);
        return toResult(map);
    }

    public String deleteProcessQuotedPriceItem(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        processQuotedPriceItemApplication.deleteByIds(ids);
        return success();
    }

    public String queryProcessQuotedPriceItemNumbers(){
        SDO sdo = this.getSDO();
        ProcessQuotedPriceQueryRequest queryRequest = sdo.toQueryRequest(ProcessQuotedPriceQueryRequest.class);
        Map<String, Object> map = this.processQuotedPriceItemNumberApplication.queryProcessQuotedPriceItemNumbers(queryRequest);
        return toResult(map);
    }

    public String deleteProcessQuotedPriceItemNumber(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        processQuotedPriceItemNumberApplication.deleteByIds(ids);
        return success();
    }

    public String showBindProcessQuotedPrice(){
        SDO sdo = this.getSDO();
        String string = sdo.getString("itemId");
        String productCode = sdo.getString("productCode");
        String outProcess = sdo.getString("outProcess");
        this.putAttribute("string",string);
        this.putAttribute("productCode",productCode);
        this.putAttribute("outProcess",outProcess);
        return forward("processQuotedPriceNumber");
    }

    /**
     * 单独保存数量区间报价
     * @return
     */
    public String saveProcessQuotedPriceItemNumber(){
        SDO sdo = this.getSDO();
        String itemId = sdo.getString("itemId");
        List<ProcessQuotedPriceItemNumber> numberList = sdo.getList("numberList", ProcessQuotedPriceItemNumber.class);
        processQuotedPriceItemNumberApplication.saveProcessQuotedPriceItemNumbers(itemId,numberList);
        return success();
    }

    /**
     * 查询数量区间报价
     * @return
     */
    public String queryProcessQuotedPriceItemNumber(){
        SDO sdo = this.getSDO();
        String itemId = sdo.getString("itemId");
        List<ProcessQuotedPriceItemNumber> itemNumberList = processQuotedPriceItemNumberApplication.findByProcessQuotedPriceItemId(itemId);
        return packGridDataAndResult(itemNumberList);
    }

    /**
     * 启用、禁用报价单明细
     * @return
     */
    public String updateProcessQuotedPriceItemStatus(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        String status = sdo.getString("status");
        processQuotedPriceItemApplication.updateProcessQuotedPriceItemStatus(ids,status);
        return success();
    }

    public String print(){
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        Map<String,Object> map = this.processQuotedPriceItemApplication.print(id);
        String pintPage = String.format("/print/topsun/processQuotedPrice.ftl");
        return outputAndProcUnitHandlerPDF(pintPage, id, map);
    }

    public String findPriceByProductAndProcess(){
        SDO sdo = this.getSDO();
        String productCode = sdo.getString("productCode");
        String outProcess = sdo.getString("outProcess");
        String number = sdo.getString("number");
        String lifnr = sdo.getString("lifnr");
        ProcessQuotedPriceAndMwskzVo data = new ProcessQuotedPriceAndMwskzVo();
        if (StringUtil.isNotBlank(number)){
            data = this.processQuotedPriceItemApplication.findPriceByProductAndProcess(data,productCode, outProcess, new BigDecimal(number),lifnr);
        }
        return success(data);
    }
}
