package com.huigou.topsun.sap.processOutsource.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @Auther: xin.lu
 * @Date: 2024/08/02/9:42
 * @Description: 工序外协申请单
 */
@Data
@Entity
@Table(name = "sap_process_outsource")
public class ProcessOutsource extends FlowBillAbstractEntity {

    @Column(name = "werks")
    private String werks;

    @Column(name = "werks_name")
    private String werksName;

    /**
     * 情况说明
     */
    @Column(name = "situation_desc")
    private String situationDesc;

    /**
     * 工序外协类别
     * normal 常规
     * proofing 打样
     */
    @Column(name = "process_out_type")
    private String processOutType;

    @Override
    protected String getCodeRuleId() {
        return "processOutsource";
    }
}
