package com.huigou.topsun.sap.processOutsource.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.processOutsource.application.ProcessOutsourceMaterialApplication;
import com.huigou.topsun.sap.processOutsource.domain.ProcessOutsourceMaterial;
import com.huigou.topsun.sap.processOutsource.domain.query.ProcessOutsourceQueryRequest;
import com.huigou.topsun.sap.processOutsource.repository.ProcessOutsourceMaterialRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/08/02/10:02
 * @Description:
 */
@Service("processOutsourceMaterialApplication")
public class ProcessOutsourceMaterialApplicationImpl extends BaseApplication implements ProcessOutsourceMaterialApplication {
    @Autowired
    private ProcessOutsourceMaterialRepository processOutsourceMaterialRepository;
    @Override
    public void saveProcessOutsourceMaterials(String processOutsourceMaterialId, List<ProcessOutsourceMaterial> processOutsourceMaterialItems) {
        processOutsourceMaterialItems.forEach(processOutsourceMaterialItem->{
            processOutsourceMaterialItem.setProcessOutsourceId(processOutsourceMaterialId);
            processOutsourceMaterialRepository.save(processOutsourceMaterialItem);
        });
    }

    @Override
    public Map<String, Object> queryProcessOutsourceMaterials(ProcessOutsourceQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getProcessOutsourceId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "processOutsourceMaterialItems");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            processOutsourceMaterialRepository.delete(id);
        });
    }

    @Override
    public List<ProcessOutsourceMaterial> findByProcessOutsourceId(String processOutsourceId) {
        return processOutsourceMaterialRepository.findByProcessOutsourceId(processOutsourceId);
    }
}
