package com.huigou.topsun.sap.permit.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;

import com.huigou.topsun.common.CommonUtils;
import com.huigou.topsun.sap.permit.application.SapPermitApplication;
import com.huigou.topsun.sap.permit.application.SapPermitItemApplication;
import com.huigou.topsun.sap.permit.domain.SapPermit;
import com.huigou.topsun.sap.permit.domain.SapPermitItem;
import com.huigou.topsun.sap.permit.domain.query.SapPermitQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.tool.dataimport.application.ExcelImportApplication;
import com.huigou.util.ClassHelper;
import com.huigou.util.CommonUtil;
import com.huigou.util.SDO;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**放行条
 * @Auther: LXH
 * @Date: 2024/03/26 10:10
 * @Description:
 */
@Controller
@ControllerMapping("/sapPermit")
public class SapPermitController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/permit/";
    }

    @Resource
    private SapPermitApplication sapPermitApplication;
    @Autowired
    private SapPermitItemApplication sapPermitItemApplication;

    private ExcelImportApplication excelImportApplication;

    public String forwardSapPermitList(){
        return forward("sapPermitList");
    }

    public String slicedSapPermitList(){
        SDO sdo = this.getSDO();
        SapPermitQueryRequest queryRequest = sdo.toQueryRequest(SapPermitQueryRequest.class);
        Map<String, Object> map = sapPermitApplication.getPermitList(queryRequest);
        return toResult(map);
    }

    public String forwardSapPermitDetail(){
        this.putAttribute("processDefinitionKey", SapPermitApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        SapPermit sapPermit = new SapPermit();
        sapPermit.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
       // sapPermit.setAttbizId(CommonUtil.createGUID()); // 自动生成附件id
        Operator operator = getOperator();
        sapPermit.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
       // ExcelImportTemplate excelImportTemplate=excelImportApplication.loadExcelImportTemplateByCode("sapPermitData");
        return forward("sapPermitDetail",sapPermit);
    }

    public String showPermit(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
       // this.putAttribute("attbizId", id); // 设置附件id
        SapPermit sapPermit = sapPermitApplication.getPermitById(id);
       // sapRetirement.setAttbizId(id);
        return forward("sapPermitDetail",sapPermit);
    }

    /**
     * 删除放行条
     */
    public String deleteSapPermit() {
        List<String> ids = this.getSDO().getIds();
        sapPermitApplication.deleteByIds(ids);
        return success();
    }

    public String printInfo() {
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        Map<String, Object> data = this.sapPermitApplication.printInfo(id);
        return outputAndProcUnitHandlerPDF("/permit.ftl", id, data);
    }
}
