package com.huigou.topsun.sap.nonProducePick.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/13/9:33
 * @Description: SAP非生产性领料申请与发料过账
 */
@Data
public class PDANonProducePickItemVo implements Serializable {
    /**
     * 预留/相关需求的编号
     */
    @JsonProperty("RSNUM")
    private String message;

    /**
     * 工厂
     */
    @JsonProperty("WERKS")
    private String werks;

    /**
     * 成本中心
     */
    @JsonProperty("KOSTL")
    private String kostl;

    /**
     *序号
     */
    @JsonProperty("RSPOS")
    private String rspos;

    /**
     * 物料编号
     */
    @JsonProperty("MATNR")
    private String matnr;

    /**
     *物料描述
     */
    @JsonProperty( "MAKTX")
    private String maktx;

    /**
     * 存储地点
     */
    @JsonProperty("LGORT")
    private String lgort;

    /**
     * 录入单位
     */
    @JsonProperty("ERFME")
    private String meins;

    /**
     * 以录入项单位表示的数量
     */
    @JsonProperty("ERFMG")
    private BigDecimal erfmg;

    /**
     * 收货方
     */
    @JsonProperty("WEMPF")
    private String wempf;

    /**
     * 用途
     */
    @JsonProperty("ZYTBM")
    private String used;

    /**
     * 用途描述
     */
    @JsonProperty("ZTEXT")
    private String ztext;

    /**
     *退料数量
     */
    @JsonProperty("BACK_NUM")
    private BigDecimal backNum;

    /**
     *退料时间
     */
    @JsonProperty("BACK_DATE")
    private String backDate;

    /**
     * 实际退料数量
     */
    @JsonProperty("ZERFMG")
    private BigDecimal zerfmg;

    public BigDecimal getZerfmg() {
        return zerfmg;
    }

    public void setZerfmg(BigDecimal zerfmg) {
        if (zerfmg == null) {
            zerfmg = BigDecimal.ZERO;
        }
        this.zerfmg = zerfmg;
    }
}
