package com.huigou.topsun.sap.nonProducePick.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/13/9:33
 * @Description: SAP非生产性领料申请与发料过账
 */
@Data
public class NonProducePickVo implements Serializable {
    /**
     * 预留/相关需求的编号
     */
    @JsonProperty("RSNUM")
    private String rsnum;

    /**
     * 工厂
     */
    @JsonProperty("WERKS")
    private String werks;

    /**
     * 用户名
     */
    @JsonProperty("USNAM")
    private String usnam;

    /**
     * 成本中心
     */
    @JsonProperty("KOSTL")
    private String kostl;

    /**
     * 移动类型(库存管理)
     */
    @JsonProperty("BWART")
    private String bwart;

    /**
     * 收货方
     */
    @JsonProperty("WEMPF")
    private String wempf;

    /**
     * 订单编号
     */
    @JsonProperty("AUFNR")
    private String aufnr;

    /**
     *预订基准日期
     */
    @JsonProperty("BSTER")
    private String bster;

    /**
     * 标识
     * Y：创建
     * N：删除
     */
    @JsonProperty("ZTYPE")
    private String ztype;

    @JsonProperty("STATE")
    private String state;

    @JsonProperty("ITEM")
    private List<NonProducePickItemVo> items;

}
