package com.huigou.topsun.sap.nonProdApply.domain;

import com.huigou.topsun.common.AbstractPortalOrg;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 *
 * @TableName tmp_non_prod_material_data
 * 物料导入模板临时数据表
 */
@Table(name="tmp_non_prod_material_data")
@Data
@Entity
public class TmpNonProdMaterialDataImport extends AbstractPortalOrg {

    @Column(name = "MATNR")
    private String matnr; // 物料编码
    
    @Column(name = "MTART")
    private String mtart; // 物料类型编码
    
    @Column(name = "MATKL_TYPE")
    private String matklType; // 物料组大类编码
    
    @Column(name = "MATKL_TYPE_NAME")
    private String matklTypeName; // 物料组大类名称
    
    @Column(name = "MATKL")
    private String matkl; // 物料组
    
    @Column(name = "MATKL_NAME")
    private String matklName; // 物料组名称
    
    @Column(name = "GROES")
    private String groes; // 规格
    
    @Column(name = "SPART")
    private String spart; // 产品组
    
    @Column(name = "SPART_NAME")
    private String spartName; // 产品组名称
    
    @Column(name = "MTPOS_MARA")
    private String mtposMara; // 销售项目类别组
    
    @Column(name = "XCHPF")
    private String xchpf; // 批次管理
    
    @Column(name = "MAKTX")
    private String maktx; // 物料描述(汉)
    
    @Column(name = "SPARS")
    private String spars; // 汉语语言码
    
    @Column(name = "MAKTX_EN")
    private String maktxEn; // 物料描述(英)
    
    @Column(name = "SPARS_EN")
    private String sparsEn; // 英语语言码
    
    @Column(name = "MEINS")
    private String meins; // 基本计量单位
    
    @Column(name = "MEINS_NAME")
    private String meinsName; // 基本计量单位名称
    
    @Column(name = "RAUBE")
    private String raube; // 存储条件
    
    @Column(name = "BRGEW")
    private String brgew; // 毛重
    
    @Column(name = "GEWEI")
    private String gewei; // 重量单位编码
    
    @Column(name = "VOLUM")
    private String volum; // 体积
    
    @Column(name = "VOLEH")
    private String voleh; // 体积单位编码
    
    @Column(name = "IPRKZ")
    private String iprkz; // 有效期标识编码
    
    @Column(name = "MHDHB")
    private String mhdhb; // 总有效期
    
    @Column(name = "MHDRZ")
    private String mhdrz; // 最小货架寿命
    
    @Column(name = "NORMT")
    private String normt; // 适用行业标准编码
    
    @Column(name = "LENGTH")
    private BigDecimal length; // 长度cm
    
    @Column(name = "WIDTH_CM")
    private BigDecimal widthCm; // 宽度cm
    
    @Column(name = "THICKNESS")
    private BigDecimal thickness; // 高度cm
    
    @Column(name = "WEIGHT")
    private BigDecimal weight; // 克重g
    
    @Column(name = "SINGLE_THICKNESS")
    private BigDecimal singleThickness; // 单层丝厚
    
    @Column(name = "KUNNR")
    private String kunnr; // 客户编码
    
    @Column(name = "KUNNR_NAME")
    private String kunnrName; // 客户名称
    
    @Column(name = "KLART")
    private String klart; // 类型
    
    @Column(name = "CLASSIFY")
    private String classify; // 分类
    
    @Column(name = "MAKTX_DESC_CN")
    private String maktxDescCn; // 文本说明中文
    
    @Column(name = "MAKTX_DESC_EN")
    private String maktxDescEn; // 文本说明英文
    
    @Column(name = "WERKS")
    private String werks; // 工厂编码
    
    @Column(name = "WERKS_NAME")
    private String werksName; // 工厂名称
    
    @Column(name = "LGORT")
    private String lgort; // 库存地点
    
    @Column(name = "LGORT_NAME")
    private String lgortName; // 库存地点名称
    
    @Column(name = "LGTYP")
    private String lgtyp; // 存储类型
    
    @Column(name = "LGTYP_NAME")
    private String lgtypName; // 存储类型名称
    
    @Column(name = "MTVFP")
    private String mtvfp; // 可用性检查组
    
    @Column(name = "VKORG")
    private String vkorg; // 销售组织
    
    @Column(name = "VKORG_NAME")
    private String vkorgName; // 销售组织名称
    
    @Column(name = "VTWEG")
    private String vtweg; // 分销渠道
    
    @Column(name = "VTWEG_NAME")
    private String vtwegName; // 分销渠道名称
    
    @Column(name = "VRKME")
    private String vrkme; // 销售计量单位
    
    @Column(name = "VRKME_NAME")
    private String vrkmeName; // 销售计量单位描述
    
    @Column(name = "UMREN_SALE")
    private String umrenSale; // 转换分母（销售）
    
    @Column(name = "UMREZ_SALE")
    private String umrezSale; // 转换分子（销售）
    
    @Column(name = "DWERK")
    private String dwerk; // 交货工厂
    
    @Column(name = "DWERK_NAME")
    private String dwerkName; // 交货工厂名称
    
    @Column(name = "ALAND")
    private String aland; // 税收发运国
    
    @Column(name = "ALAND_NAME")
    private String alandName; // 税收发运国名称
    
    @Column(name = "TAXKM")
    private String taxkm; // 税分类编码
    
    @Column(name = "VERSG")
    private String versg; // 统计组
    
    @Column(name = "KONDM")
    private String kondm; // 物料定价组
    
    @Column(name = "KTGRM")
    private String ktgrm; // 会计科目组
    
    @Column(name = "PRODH")
    private String prodh; // 产品层级
    
    @Column(name = "MVGR1")
    private String mvgr1; // 品牌
    
    @Column(name = "MVGR2")
    private String mvgr2; // 产品经营类型
    
    @Column(name = "MTPOS")
    private String mtpos; // 销售项次组
    
    @Column(name = "TRAGR")
    private String tragr; // 运输组
    
    @Column(name = "LADGR")
    private String ladgr; // 装载组
    
    @Column(name = "LADGR_NAME")
    private String ladgrName; // 装载组名称
    
    @Column(name = "BSTME")
    private String bstme; // 采购单位
    
    @Column(name = "BSTME_NAME")
    private String bstmeName; // 采购单位名称
    
    @Column(name = "UMREN_PURCH")
    private String umrenPurch; // 转换分母（采购）
    
    @Column(name = "UMREZ_PURCH")
    private String umrezPurch; // 转换分子（采购）
    
    @Column(name = "EKGRP")
    private String ekgrp; // 默认采购组
    
    @Column(name = "EKGRP_NAME")
    private String ekgrpName; // 默认采购组名称
    
    @Column(name = "MMSTA")
    private String mmsta; // 工厂特定的物料状态
    
    @Column(name = "MINBE")
    private String minbe; // 重订货点
    
    @Column(name = "DISMM")
    private String dismm; // MRP类型
    
    @Column(name = "DISPO")
    private String dispo; // MRP控制者
    
    @Column(name = "DISLS")
    private String disls; // 批量规模
    
    @Column(name = "BSTFE")
    private String bstfe; // 固定批量
    
    @Column(name = "BSTMA")
    private String bstma; // 最大批量
    
    @Column(name = "BSTMI")
    private String bstmi; // 最小批量
    
    @Column(name = "MABST")
    private String mabst; // 最大存货水平
    
    @Column(name = "BSTRF")
    private String bstrf; // 舍入值
    
    @Column(name = "BESKZ")
    private String beskz; // 获取类型
    
    @Column(name = "SOBSL")
    private String sobsl; // 特殊获取方式
    
    @Column(name = "RGEKZ")
    private String rgekz; // 倒冲标志
    
    @Column(name = "WEBAZ")
    private String webaz; // 收货处理天数
    
    @Column(name = "RAUBE_NAME")
    private String raubeName; // 存储条件名称
    
    @Column(name = "DZEIT")
    private String dzeit; // 自制时间
    
    @Column(name = "FHORI")
    private String fhori; // 排程边际码
    
    @Column(name = "EISBE")
    private String eisbe; // 安全库存
    
    @Column(name = "EISLO")
    private String eislo; // 最小安全库存
    
    @Column(name = "STRGR")
    private String strgr; // 计划策略组
    
    @Column(name = "WZEIT")
    private String wzeit; // 补货提前天数
    
    @Column(name = "SBDKZ")
    private String sbdkz; // 独立/集中
    
    @Column(name = "VRMOD")
    private String vrmod; // 消耗模式
    
    @Column(name = "VINT1")
    private String vint1; // 逆推消耗期间
    
    @Column(name = "LTKZE")
    private String ltkze; // 存货上架存储类型
    
    @Column(name = "VINT2")
    private String vint2; // 顺推消耗期间
    
    @Column(name = "LTKZE_NAME")
    private String ltkzeName; // 存货上架存储类型名称
    
    @Column(name = "PERKZ")
    private String perkz; // 期间标识
    
    @Column(name = "LGBKZ")
    private String lgbkz; // 存储分区标识
    
    @Column(name = "PLIFZ")
    private String plifz; // 外采交货时间
    
    @Column(name = "LGBKZ_NAME")
    private String lgbkzName; // 存储分区标识名称
    
    @Column(name = "DISKZ")
    private String diskz; // 库存地MRP标识
    
    @Column(name = "LGPRO")
    private String lgpro; // 默认生产存储地
    
    @Column(name = "LGPRO_NAME")
    private String lgproName; // 默认生产存储地名称
    
    @Column(name = "LGFSB")
    private String lgfsb; // 采购采购默认存储地
    
    @Column(name = "LGFSB_NAME")
    private String lgfsbName; // 采购采购默认存储地名称
    
    @Column(name = "AUSME")
    private String ausme; // 投料计量单位
    
    @Column(name = "AUSME_NAME")
    private String ausmeName; // 投料计量单位名称
    
    @Column(name = "UMREN_PROD")
    private String umrenProd; // 转换分母（生产）
    
    @Column(name = "UMREZ_PROD")
    private String umrezProd; // 转换分子（生产）
    
    @Column(name = "UEETK")
    private String ueetk; // 允许未限制的过量交货
    
    @Column(name = "FEVOR")
    private String fevor; // 生产主管
    
    @Column(name = "SFCPF")
    private String sfcpf; // 生产计划参数文件
    
    @Column(name = "LGORT_QM")
    private String lgortQm; // 库存地点（存储）
    
    @Column(name = "LGORT_QM_NAME")
    private String lgortQmName; // 库存地点名称（存储）
    
    @Column(name = "SERNP")
    private String sernp; // 序列号参数
    
    @Column(name = "SERLV")
    private String serlv; // 序列号水平
    
    @Column(name = "PRCTR")
    private String prctr; // 利润中心
    
    @Column(name = "INSMK")
    private String insmk; // 检验过账
    
    @Column(name = "SLED_BBD")
    private String sledBbd; // 过期日期
    
    @Column(name = "LGNUM")
    private String lgnum; // 仓库号
    
    @Column(name = "LGNUM_NAME")
    private String lgnumName; // 仓库号名称
    
    @Column(name = "LGORT_PROFIT_NAME")
    private String lgortProfitName; // 库存地点（仓库）
    
    @Column(name = "LGORT_PROFIT")
    private String lgortProfit; // 库存地点名称（仓库）
    
    @Column(name = "LETY1")
    private String lety1; // 仓库设施1类型
    
    @Column(name = "LHMG1")
    private String lhmg1; // 仓库设施1存储数量
    
    @Column(name = "LHME1")
    private String lhme1; // 仓库设施1存储单位
    
    @Column(name = "LHME1_NAME")
    private String lhme1Name; // 仓库设施1存储单位描述
    
    @Column(name = "LTKZA")
    private String ltkza; // 存货下架存储类型
    
    @Column(name = "LTKZA_NAME")
    private String ltkzaName; // 存货下架存储类型名称
    
    @Column(name = "BKLAS")
    private String bklas; // 评估分类
    
    @Column(name = "VPRSV")
    private String vprsv; // 价格控制
    
    @Column(name = "MLAST")
    private String mlast; // 价格确定
    
    @Column(name = "PEINH")
    private String peinh; // 定价基数
    
    @Column(name = "NCOST")
    private String ncost; // 不参与成本核算
    
    @Column(name = "HKMAT")
    private String hkmat; // 物料来源
    
    @Column(name = "EKALR")
    private String ekalr; // 根据数量结构进行成本核算
    
    @Column(name = "AWSLS")
    private String awsls; // 差异码
    
    @Column(name = "EKLAS")
    private String eklas; // 销售评估类

    // 这里省略getter和setter方法
}