package com.huigou.topsun.sap.nonProdApply.domain;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 
 * @TableName sap_non_prod_apply_dept
 */
@Table(name="sap_non_prod_apply_dept")
@Data
@Entity
public class SapNonProdApplyDept implements Serializable {


    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "apply_dept_id")
    private String applyDeptId;

    /**
     * 主表id
     */
    @Column(name = "base_info_id")
    private String baseInfoId;



    /**
     * 物料编码
     */
    @Column(name = "MATNR")
    private String matnr;

    //行业
    @Column(name = "MBRSH")
    private String mbrsh;

    /**
     * 物料类型
     */
    @Column(name = "MTART")
    private String mtart;

    /**
     * 物料组
     */
    @Column(name = "MATKL")
    private String matkl;

    /**
     * 集团删除
     */
    @Column(name = "LVORM")
    private String lvorm;

    /**
     * 产品组
     */
    @Column(name = "SPART")
    private String spart;

    /**
     * 一般销售项次组
     */
    @Column(name = "MTPOS_MARA")
    private String mtposMara;

    /**
     * 汉语品名
     */
    @Column(name = "MAKTX")
    private String maktx;

    /**
     * 汉语语言
     */
    @Column(name = "SPARS")
    private String spars;

    /**
     * 英语品名
     */
    @Column(name = "MAKTX_EN")
    private String maktxEn;

    /**
     * 英语语言码
     */
    @Column(name = "SPARS_EN")
    private String sparsEn;

    /**
     * 适用标准
     */
    @Column(name = "NORMT")
    private String normt;


    /**
     * 尺寸
     */
    @Column(name = "GROES")
    private String groes;

    /**
     * 批次管理
     */
    @Column(name = "XCHPF")
    private String xchpf;

    /**
     * 包装物料组
     */
    @Column(name = "MAGRV")
    private String magrv;

    /**
     * 基本计量单位
     */
    @Column(name = "MEINS")
    private String meins;
    @Column(name = "meins_name")
    private String meinsName;

    /**
     * 毛重
     */
    @Column(name = "BRGEW")
    private String brgew;

    /**
     * 净重
     */
    @Column(name = "NTGEW")
    private String ntgew;

    /**
     * 重量单位
     */
    @Column(name = "GEWEI")
    private String gewei;

    /**
     * 体积
     */
    @Column(name = "VOLUM")
    private String volum;

    /**
     * 体积单位
     */
    @Column(name = "VOLEH")
    private String voleh;

    /**
     * 存储条件
     */
    @Column(name = "RAUBE")
    private String raube;

    /**
     * 有效期标识
     */
    @Column(name = "IPRKZ")
    private String iprkz;

    /**
     * 最小货架寿命
     */
    @Column(name = "MHDRZ")
    private String mhdrz;

    /**
     * 总有效期
     */
    @Column(name = "MHDHB")
    private String mhdhb;

    /**
     * 类型
     */
    @Column(name = "KLART")
    private String klart;

    /**
     * 分类
     */
    @Column(name = "CLASS")
    private String classify;

    /**
     * 销售组织
     */
    @Column(name = "VKORG")
    private String vkorg;

    /**
     * 分销渠道
     */
    @Column(name = "VTWEG")
    private String vtweg;

    /**
     * 销售计量单位
     */
    @Column(name = "VRKME")
    private String vrkme;

    /**
     * 销售计量单位转换分母
     */
    @Column(name = "UMREN_SALE")
    private String umrenSale;

    /**
     * 销售计量单位转换分子
     */
    @Column(name = "UMREZ_SALE")
    private String umrezSale;

    /**
     * 转换分母
     */
    @Column(name = "UMREN")
    private String umren;

    /**
     * 转换分子
     */
    @Column(name = "UMREZ")
    private String umrez;

    /**
     * 交货工厂
     */
    @Column(name = "DWERK")
    private String dwerk;

    @Column(name = "DWERK_NAME")
    private String dwerkName;
    /**
     * 税收发运国
     */
    @Column(name = "ALAND")
    private String aland;

    @Column(name = "ALAND_NAME")
    private String alandName;
    /**
     * 税分类
     */
    @Column(name = "TAXKM")
    private String taxkm;

    /**
     * 统计组
     */
    @Column(name = "VERSG")
    private String versg;

    /**
     * 物料定价组
     */
    @Column(name = "KONDM")
    private String kondm;

    /**
     * 会计科目组
     */
    @Column(name = "KTGRM")
    private String ktgrm;

    /**
     * 产品层级
     */
    @Column(name = "PRODH")
    private String prodh;

    /**
     * 版式
     */
    @Column(name = "MVGR1")
    private String mvgr1;

    /**
     * 品牌
     */
    @Column(name = "MVGR2")
    private String mvgr2;

    /**
     * 用途
     */
    @Column(name = "MVGR3")
    private String mvgr3;

    /**
     * 备用
     */
    @Column(name = "MVGR4")
    private String mvgr4;

    /**
     * 备用
     */
    @Column(name = "MVGR5")
    private String mvgr5;

    /**
     * 销售项次组
     */
    @Column(name = "MTPOS")
    private String mtpos;

    /**
     * 运输组
     */
    @Column(name = "TRAGR")
    private String tragr;

    /**
     * 装载组
     */
    @Column(name = "LADGR")
    private String ladgr;

    /**
     * 工厂
     */
    @Column(name = "WERKS")
    private String werks;

    /**
     * 采购计量单位
     */
    @Column(name = "BSTME")
    private String bstme;

    @Column(name = "bstme_name")
    private String bstmeName;

    /**
     * 转换分母（采购）
     */
    @Column(name = "UMREN_PURCH")
    private String umrenPurch;

    /**
     * 转换分子（采购）
     */
    @Column(name = "UMREZ_PURCH")
    private String umrezPurch;

    /**
     * 默认采购组
     */
    @Column(name = "EKGRP")
    private String ekgrp;

    /**
     * MPN参数
     */
    @Column(name = "MPROF")
    private String mprof;

    /**
     * 工厂（采购）
     */
    @Column(name = "WERKS_PURCH")
    private String werksPurch;

    /**
     * 库存地点
     */
    @Column(name = "LGORT")
    private String lgort;

    /**
     * MRP组
     */
    @Column(name = "DISGR")
    private String disgr;

    /**
     * MRP类型
     */
    @Column(name = "DISMM")
    private String dismm;

    /**
     * 重订货点
     */
    @Column(name = "MINBE")
    private String minbe;

    /**
     * MRP控制者
     */
    @Column(name = "DISPO")
    private String dispo;

    /**
     * 批量规模
     */
    @Column(name = "DISLS")
    private String disls;

    /**
     * 固定批量
     */
    @Column(name = "BSTFE")
    private String bstfe;

    /**
     * 最大批量
     */
    @Column(name = "BSTMA")
    private String bstma;

    /**
     * 最小批量
     */
    @Column(name = "BSTMI")
    private String bstmi;

    /**
     * 最大存货水平
     */
    @Column(name = "MABST")
    private String mabst;

    /**
     * 设入值
     */
    @Column(name = "BSTRF")
    private String bstrf;

    /**
     * 获取类型
     */
    @Column(name = "BESKZ")
    private String beskz;

    /**
     * 特殊获取方式
     */
    @Column(name = "SOBSL")
    private String sobsl;

    /**
     * 默认生产库存地
     */
    @Column(name = "LGPRO")
    private String lgpro;
    @Column(name = "lgpro_name")
    private String lgproName;

    /**
     * 倒冲标志
     */
    @Column(name = "RGEKZ")
    private String rgekz;

    /**
     * 默认采购收货库存地
     */
    @Column(name = "LGFSB")
    private String lgfsb;

    @Column(name = "lgfsb_name")
    private String lgfsbName;

    /**
     * 收货处理天数
     */
    @Column(name = "WEBAZ")
    private String webaz;

    /**
     * 自制时间
     */
    @Column(name = "DZEIT")
    private String dzeit;

    /**
     * 外部采购交货时间
     */
    @Column(name = "PLIFZ")
    private String plifz;

    /**
     * 排程边际码
     */
    @Column(name = "FHORI")
    private String fhori;

    /**
     * 安全库存
     */
    @Column(name = "EISBE")
    private String eisbe;

    /**
     * 最小安全库存
     */
    @Column(name = "EISLO")
    private String eislo;

    /**
     * 策略组
     */
    @Column(name = "STRGR")
    private String strgr;

    /**
     * 可用性检查组
     */
    @Column(name = "MTVFP")
    private String mtvfp;

    /**
     * 补货提前天数
     */
    @Column(name = "WZEIT")
    private String wzeit;

    /**
     * BOM选择方法
     */
    @Column(name = "ALTSL")
    private String altsl;

    /**
     * 独立/集中
     */
    @Column(name = "SBDKZ")
    private String sbdkz;

    /**
     * 库存地MRP标识
     */
    @Column(name = "DISKZ")
    private String diskz;

    /**
     * 投料计量单位
     */
    @Column(name = "AUSME")
    private String ausme;
    @Column(name = "ausme_name")
    private String ausmeName;

    /**
     * 转换分母（生产）
     */
    @Column(name = "UMREN_PROD")
    private String umrenProd;

    /**
     * 转换分子（生产）
     */
    @Column(name = "UMREZ_PROD")
    private String umrezProd;

    /**
     * 生产计划参数文件
     */
    @Column(name = "SFCPF")
    private String sfcpf;

    /**
     * 过账到质检
     */
    @Column(name = "INSMK")
    private String insmk;

    /**
     * 工厂（质检）
     */
    @Column(name = "WERKS_QM")
    private String werksQm;

    /**
     * 库存地点（存储）
     */
    @Column(name = "LGORT_QM")
    private String lgortQm;

    @Column(name = "LGORT_QM_NAME")
    private String lgortQmName;
    /**
     * 序列号参数
     */
    @Column(name = "SERNP")
    private String sernp;

    /**
     * 序列号水平
     */
    @Column(name = "SERLV")
    private String serlv;

    /**
     * 利润中心
     */
    @Column(name = "PRCTR")
    private String prctr;

    /**
     * 工厂（利润中心）
     */
    @Column(name = "WERKS_PROFIT")
    private String werksProfit;

    /**
     * 库存地点（仓库）
     */
    @Column(name = "LGORT_PROFIT")
    private String lgortProfit;

    @Column(name = "LGORT_PROFIT_NAME")
    private String lgortProfitName;
    /**
     * 仓库号
     */
    @Column(name = "LGNUM")
    private String lgnum;

    /**
     * 存储类型
     */
    @Column(name = "LGTYP")
    private String lgtyp;

    /**
     * 存货下架存储类型
     */
    @Column(name = "LTKZA")
    private String ltkza;

    @Column(name = "ltkza_name")
    private String ltkzaName;

    /**
     * 存货上架存储类型
     */
    @Column(name = "LTKZE")
    private String ltkze;

    @Column(name = "ltkze_name")
    private String ltkzeName;

    /**
     * 存储分区标识
     */
    @Column(name = "LGBKZ")
    private String lgbkz;

    @Column(name = "lgbkz_name")
    private String lgbkzName;

    /**
     * 仓库设施1存储数量
     */
    @Column(name = "LHMG1")
    private String lhmg1;

    /**
     * 仓库设施1存储单位
     */
    @Column(name = "LHME1")
    private String lhme1;

    @Column(name = "lhme1_name")
    private String lhme1Name;

    /**
     * 仓库设施1类型
     */
    @Column(name = "LETY1")
    private String lety1;

    /**
     * 工厂（文档要求）
     */
    @Column(name = "WERKS_DOC")
    private String werksDoc;

    /**
     * 文档要求
     */
    @Column(name = "KZDKZ")
    private String kzdkz;

    /**
     * 检验类型
     */
    @Column(name = "ART")
    private String art;

    /**
     * 激活标识
     */
    @Column(name = "AKTIV")
    private String aktiv;

    /**
     * 过账到质检（质检）
     */
    @Column(name = "INSMK_QM")
    private String insmkQm;

    /**
     * 带任务清单检验
     */
    @Column(name = "PPL")
    private String ppl;

    /**
     * 自动分配
     */
    @Column(name = "APP")
    private String app;

    /**
     * 检查特性
     */
    @Column(name = "MER")
    private String mer;

    /**
     * 允许略过
     */
    @Column(name = "DYN")
    private String dyn;

    /**
     * 工厂（评估分类）
     */
    @Column(name = "BWKEY")
    private String bwkey;

    /**
     * 评估分类
     */
    @Column(name = "BKLAS")
    private String bklas;

    /**
     * 价格确定
     */
    @Column(name = "MLAST")
    private String mlast;

    /**
     * 价格控制
     */
    @Column(name = "VPRSV")
    private String vprsv;

    /**
     * 定价基数
     */
    @Column(name = "PEINH")
    private String peinh;

    /**
     * 移动平均价
     */
    @Column(name = "VERPR")
    private String verpr;

    /**
     * 标准价
     */
    @Column(name = "STPRS")
    private String stprs;

    /**
     * 数量结构
     */
    @Column(name = "EKALR")
    private String ekalr;

    /**
     * 不参与成本核算
     */
    @Column(name = "NCOST")
    private String ncost;

    /**
     * 物料来源
     */
    @Column(name = "HKMAT")
    private String hkmat;

    /**
     * 差异码
     */
    @Column(name = "AWSLS")
    private String awsls;


    /**
     * 消耗模式
     */
    @Column(name = "VRMOD")
    private String vrmod;

    /**
     * 逆推消耗期间
     */
    @Column(name = "VINT1")
    private String vint1;

    /**
     * 顺推消耗期间
     */
    @Column(name = "VINT2")
    private String vint2;


    /**
     * 综合MRP
     */
    @Column(name = "MISKZ")
    private String miskz;


    //期间标识
    @Column(name = "PERKZ")
    private String perkz;

    //生产主管
    @Column(name = "FEVOR")
    private String fevor;


    //过期日期
    @Column(name = "SLED_BBD")
    private String sledBbd;


    //销售评估类
    @Column(name = "EKLAS")
    private String eklas;

    /**
     * 维护状态（0草稿；1保存；2分发）
     */
    @Column(name = "STATUS")
    private String status;

    @Column(name = "matkl_name")
    private String matklName;

    @Column(name = "matkl_type")
    private String matklType;

    @Column(name = "matkl_type_name")
    private String matklTypeName;

    @Column(name = "spart_name")
    private String spartName;

    @Column(name = "werks_name")
    private String werksName;

    @Column(name = "lgort_name")
    private String lgortName;

    @Column(name = "vkorg_name")
    private String vkorgName;

    @Column(name = "vtweg_name")
    private String vtwegName;

    @Column(name = "lgnum_name")
    private String lgnumName;

    @Column(name = "lgtyp_name")
    private String lgtypName;

    @Column(name = "ekgrp_name")
    private String ekgrpName;

    @Column(name = "raube_name")
    private String raubeName;

    @Column(name = "dispo_name")
    private String dispoName;

    @Column(name = "minbe_name")
    private String minbeName;

    @Column(name = "ladgr_name")
    private String ladgrName;

    @Column(name = "vrkme_name")
    private String vrkmeName;

//    @Column(name = "sfcpf_name")
//    private String sfcpfName;

    @Column(name = "fevor_name")
    private String fevorName;

    @Transient
    private String billCode;
    @Transient
    private Integer statusId;
    @Transient
    private String personMemberName;
    @Transient
    private Date fillinDate;
    @Transient
    private String maintenanceType;
    @Transient
    private String businessUsage;
    @Transient
    private String businessCode;
    @Transient
    private String id; //baseInfoId

    //物品总属性
    @Transient
    private String genericName;
    @Transient
    private String applicableStandard;
    @Transient
    private String  baseUnit;
    @Transient
    private String specifications;
    @Transient
    private String material;
    @Transient
    private String design;
    @Transient
    private String  size;
    @Transient
    private String  brand;
    @Transient
    private String  brandName;
    @Transient
    private String materialUsage;
    @Transient
    private String itemAttributes;
    @Transient
    private Integer distribute;
    @Transient
    private String kind;

    @Transient
    private String maktxRemZh;
    @Transient
    private String maktxRemEn;
    @Transient
    private String textDescription;
    @Transient
    private String baseUnitName;

    @Transient
    private Date createdDate;

    /**
     *EP BOM原材料信息
     */
    //长度cm
    @Column(name = "length")
    private BigDecimal length;

    //宽度cm
    @Column(name = "width_cm")
    private BigDecimal widthCm;

    //厚度cm
    @Column(name = "thickness")
    private BigDecimal thickness;

    //克重g
    @Column(name = "weight")
    private BigDecimal weight;

    //单层厚
    @Column(name = "single_thickness")
    private BigDecimal singleThickness;

    /**
     * 工厂特定的物料状态
     */
    @Column(name = "MMSTA")
    private String mmsta;

    //允许未限制的过量交货
    @Column(name = "UEETK")
    private String ueetk;

    /**
     * 禁用原因
     */
    @Column(name = "disable_reason")
    private String disableReason;

    /**
     * 启用原因
     */
    @Column(name = "enable_reason")
    private String enableReason;

    /**
     * 客户编码
     */
    @Column(name = "kunnr")
    private String kunnr;

    /**
     * 客户名称
     */
    @Column(name = "kunnr_name")
    private String kunnrName;

    private static final long serialVersionUID = 1L;
}