package com.huigou.topsun.sap.nonProdApply.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author xin.lu
 * @Description:
 * @date 2025/3/1717:17
 */
@Data
@Entity
@Table(name = "sap_material_name_element")
public class MaterialNameElement extends AbstractEntity {

    /**
     * 单据编号
     */
    @Column(name = "bill_code")
    private String billCode;

    /**
     * 代号
     */
    @Column(name = "code")
    private String code;

    /**
     * 品牌
     */
    @Column(name = "brand")
    private String brand;
    /**
     * 品牌名称
     */
    @Column(name = "brand_name")
    private String brandName;

    /**
     * 行业
     */
    @Column(name = "industry")
    private String industry;

    /**
     * 功能
     */
    @Column(name = "function_desc")
    private String functionDesc;

    /**
     * 形状（角）
     */
    @Column(name = "shape")
    private String shape;

    /**
     * 品名
     */
    @Column(name = "base_name")
    private String baseName;

    /**
     * 季度
     */
    @Column(name = "quarter")
    private String quarter;

    /**
     * 材质
     */
    @Column(name = "material")
    private String material;

    /**
     * 颜色
     */
    @Column(name = "color")
    private String color;

    /**
     * 规格mm
     */
    @Column(name = "specifications")
    private String specifications;

    /**
     * 厚度cm
     */
    @Column(name = "thickness")
    private BigDecimal thickness;

    /**
     * 克重g
     */
    @Column(name = "weight")
    private BigDecimal weight;

    /**
     * 长文本内容
     */
    @Column(name = "maktx_rem_zh")
    private String maktxRemZh;

}
