package com.huigou.topsun.sap.nonProdApply.application.impl;

import com.huigou.topsun.sap.nonProdApply.domain.NonProdApplyBaseInfo;
import com.huigou.topsun.sap.nonProdApply.domain.SapNonProdApplyDept;
import com.huigou.topsun.sap.nonProdApply.domain.TmpNonProdMaterialDataImport;
import com.huigou.topsun.sap.nonProdApply.repository.NonProdApplyBaseInfoRepository;
import com.huigou.topsun.sap.nonProdApply.repository.NonProdApplyDeptRepository;
import com.huigou.topsun.sap.nonProdApply.repository.TmpNonProdMaterialDataImportRepository;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.tool.dataimport.application.ExcelImportInterface;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service("nonProdMaterialDataExcelImport")
public class NonProdMaterialDataExcelImport implements ExcelImportInterface {


    @Autowired
    private TmpNonProdMaterialDataImportRepository tmpNonProdMaterialDataImportRepository;
    @Autowired
    private NonProdApplyBaseInfoRepository nonProdApplyBaseInfoRepository;
    @Autowired
    private NonProdApplyDeptRepository nonProdApplyDeptRepository;
    @Override
    public void executeImport(String batchNumber) {
        List<TmpNonProdMaterialDataImport> dataImportList = tmpNonProdMaterialDataImportRepository.findByBatchNumber(batchNumber);
        for (TmpNonProdMaterialDataImport tmpNonProdMaterialDataImport : dataImportList) {
            NonProdApplyBaseInfo nonProdApplyBaseInfo = new NonProdApplyBaseInfo();
            //维护类型 ：new 新建 modify 变更 extend 扩展
            nonProdApplyBaseInfo.setMaintenanceType("new");
            //通用品名
            nonProdApplyBaseInfo.setGenericName(tmpNonProdMaterialDataImport.getMaktx());
            //基本计量单位
            nonProdApplyBaseInfo.setBaseUnit(tmpNonProdMaterialDataImport.getMeins());
            nonProdApplyBaseInfo.setBaseUnitName(tmpNonProdMaterialDataImport.getMeinsName());
            //物品属性
            nonProdApplyBaseInfo.setItemAttributes(tmpNonProdMaterialDataImport.getMtart());
            //文本说明
            nonProdApplyBaseInfo.setTextDescription(tmpNonProdMaterialDataImport.getMaktxDescCn());
            //处理状态：  0 待提交  2 已办结
            nonProdApplyBaseInfo.setDistribute(2);
            nonProdApplyBaseInfo.setDefaultValues();
            //审批状态已完成
            nonProdApplyBaseInfo.setStatusId(BizBillStatus.COMPLETED.getId());

            //设置类型
            if ("ZZCP".equals(tmpNonProdMaterialDataImport.getMtart())
                ||"ZBCP".equals(tmpNonProdMaterialDataImport.getMtart())
                || "ZSHB".equals(tmpNonProdMaterialDataImport.getMtart())){
                nonProdApplyBaseInfo.setKind("product");
            }else {
                nonProdApplyBaseInfo.setKind("material");
            }
            nonProdApplyBaseInfo.setMaktxRemZh(tmpNonProdMaterialDataImport.getMaktxDescCn());
            nonProdApplyBaseInfo.setMaktxRemEn(tmpNonProdMaterialDataImport.getMaktxDescEn());

            nonProdApplyBaseInfo.setCreatedDate(new Date());
            nonProdApplyBaseInfo.setApprover(nonProdApplyBaseInfo.getPersonMemberName());
            nonProdApplyBaseInfo.setApprovalDate(new Date());
            nonProdApplyBaseInfo.setGenericName(tmpNonProdMaterialDataImport.getMaktx());

            //用途
            nonProdApplyBaseInfo.setBusinessUsage("V,E,D,A,L,S,B");
            nonProdApplyBaseInfo = nonProdApplyBaseInfoRepository.save(nonProdApplyBaseInfo);

            //赋值基本信息维护
            SapNonProdApplyDept sapNonProdApplyDept = new SapNonProdApplyDept();
            BeanUtils.copyProperties(tmpNonProdMaterialDataImport,sapNonProdApplyDept);
            sapNonProdApplyDept.setBaseInfoId(nonProdApplyBaseInfo.getId());
            nonProdApplyDeptRepository.save(sapNonProdApplyDept);
        }
    }

}
