package com.huigou.topsun.sap.material.controller;

import com.huigou.topsun.sap.material.application.MaterialApplication;
import com.huigou.topsun.sap.material.domain.query.MaterialQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.log.annotation.LogInfo;
import com.huigou.uasp.log.domain.model.LogType;
import com.huigou.uasp.log.domain.model.OperationType;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;

/**
 * @Auther: xin.lu
 * @Date: 2023/12/15/14:37
 * @Description:
 */
@Controller
@ControllerMapping("/material")
public class MaterialController extends CommonController {

    @Resource
    private MaterialApplication materialApplication;

    @Override
    protected String getPagePath() {
        return "biz/topsun/sap/material";
    }

    @LogInfo(operaionType = OperationType.LIST, description = "跳转到物料管理页面", logType = LogType.BIZ)
    public String forwardMaterialList(){
        return forward("materialList");
    }

    @LogInfo(operaionType = OperationType.QUERY, description = "查询物料列表数据", logType = LogType.BIZ)
    public String slicedMaterialList(){
        SDO sdo = this.getSDO();
        MaterialQueryRequest queryRequest = sdo.toQueryRequest(MaterialQueryRequest.class);
        return toResult(materialApplication.slicedMaterialList(queryRequest));
    }

    @LogInfo(operaionType = OperationType.ADD, description = "跳转到添加物料详情页面", logType = LogType.BIZ)
    public String forwardAddMaterialDetail(){
        return forward("materialDetail");
    }

    @LogInfo(operaionType = OperationType.VIEW, description = "跳转到查看物料详情页面", logType = LogType.BIZ)
    public String showMaterialDetail(){
        SDO sdo = this.getSDO();
        return forward("materialDetail",null);
    }
}
