package com.huigou.topsun.sap.inventoryRecord.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * IM库存盘点
 */
@Entity
@Data
@Table(name = "sap_inventory_record_item_im")
public class InventoryRecordItemIm extends AbstractEntity {

    @Column(name = "inventory_record_id")
    private String inventoryRecordId;

    @Column(name = "IBLNR")
    private String iblnr; // 库存盘点凭证

    @Column(name = "GJAHR")
    private String gjahr; // 会计年度

    @Column(name = "ZEILI")
    private String zeili; // 行号
    
    @Column(name = "MATNR")
    private String matnr; // 物料编号

    @Column(name = "MAKTX")
    private String maktx;//物料描述
    
    @Column(name = "WERKS")
    private String werks; // 工厂

    //工厂名称
    @Column(name = "name1")
    private String name1;
    
    @Column(name = "LGORT")
    private String lgort; // 存储地点

    //存储地点名称
    @Column(name = "lgobe")
    private String lgobe;
    
    @Column(name = "CHARG")
    private String charg; // 批次编号
    
    @Column(name = "ZLDAT")
    private String zldat; // 盘点日期
    
    @Column(name = "BUCHM")
    private BigDecimal buchm; // 账面数量
    
    @Column(name = "ERFMG")
    private BigDecimal erfmg; // 盘点数量
    
    @Column(name = "DIFMG")
    private BigDecimal difmg; // 差额数量
    
    @Column(name = "MEINS")
    private String meins; // 基本计量单位

    //单位描述
    @Column(name = "MSEHL")
    private String msehl;
    
    @Column(name = "WRTZL")
    private BigDecimal wrtzl; // 盘点金额
    
    @Column(name = "WRTBM")
    private BigDecimal wrtbm; // 账面金额
    
    @Column(name = "DMBTR")
    private BigDecimal dmbtr; // 本币差额
    
    @Column(name = "WAERS")
    private String waers; // 货币码

    //货币描述
    @Column(name = "ktext")
    private String ktext;
}