package com.huigou.topsun.sap.fixedAssets.domain;

import com.huigou.topsun.common.AbstractPortalOrg;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 固定资产报废及处置导入临时表。
 *
 * @author lxh
 */
@Table(name = "tmp_fixed_retirement_data")
@Entity
@Getter
@Setter
public class TmpFixedRetirementData extends AbstractPortalOrg {
    /**
     * 主资产号
     */
    @Column(name = "anln1")
    private String anln1;

    /**
     * 公司代码（必填）
     */
    @Column(name = "bukrs")
    private String bukrs;

    /**
     * 凭证日期
     */
    @Column(name = "bldat")
    private Date bldat;

    /**
     * 过账日期
     */
    @Column(name = "BUDAT")
    private Date budat;

    /**
     * 资产起息日
     */
    @Column(name = "BZDAT")
    private Date bzdat;

    /**
     * 文本
     */
    @Column(name = "SGTXT")
    private String sgtxt;

    /**
     * 报废金额
     */
    @Column(name = "anbtr")
    private String anbtr;

    /**
     * 百分比
     */
    @Column(name = "PROZS")
    private String prozs;

    /**
     * 购置业务年度
     * 数据字典，可选：
     * 上一年度购置的业务
     * 当前年度购置的业务
     */
    @Column(name = "xa")
    private String xa;
}
