package com.huigou.topsun.sap.fixedAssets.domain;

import com.huigou.topsun.common.AbstractPortalOrg;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 在建工程转固导入临时表。
 *
 * @author lxh
 */
@Table(name = "tmp_fixed_assess_data")
@Entity
@Getter
@Setter
public class TmpFixedAssessData extends AbstractPortalOrg {
    /**
     * 主资产号
     */
    @Column(name = "anln1")
    private String anln1;

    @Column(name = "anln2")
    private String anln2;
    /**
     * 公司代码（必填）
     */
    @Column(name = "bukrs")
    private String bukrs;

    /**
     * 凭证日期
     */
    @Column(name = "bldat")
    private Date bldat;

    /**
     * 过账日期
     */
    @Column(name = "BUDAT")
    private Date budat;

    /**
     * 资产起息日
     */
    @Column(name = "BZDAT")
    private Date bzdat;

    /**
     * 文本
     */
    @Column(name = "SGTXT")
    private String sgtxt;

    /**
     * 金额
     */
    @Column(name = "betrr")
    private String betrr;

    /**
     * 百分比
     */
    @Column(name = "PROZS")
    private String prozs;

    /**
     * 接收方
     */
    @Column(name = "empge")
    private String empge;
}
