package com.huigou.topsun.sap.fixedAssets.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * SAP资产报废
 *
 * @TableName sap_retirement_item
 */
@Table(name = "sap_retirement_item")
@Entity
@Data
public class SapRetirementItem extends AbstractEntity {
    /**
     * SAP资产报废id
     */
    @Column(name = "sap_retirement_id")
    private String sapRetirementId;

    /**
     * 主资产号
     */
    @Column(name = "anln1")
    private String anln1;

    /**
     * 公司代码（必填）
     */
    @Column(name = "bukrs")
    private String bukrs;

    /**
     * 凭证日期
     */
    @Column(name = "bldat")
    private Date bldat;

    /**
     * 过账日期
     */
    @Column(name = "BUDAT")
    private Date budat;

    /**
     * 资产起息日
     */
    @Column(name = "BZDAT")
    private Date bzdat;

    /**
     * 文本
     */
    @Column(name = "SGTXT")
    private String sgtxt;

    /**
     * 报废金额
     */
    @Column(name = "anbtr")
    private BigDecimal anbtr;

    /**
     * 百分比
     */
    @Column(name = "PROZS")
    private BigDecimal prozs;

    /**
     * 购置业务年度
     * 数据字典，可选：
     * 上一年度购置的业务
     * 当前年度购置的业务
     */
    @Column(name = "xa")
    private String xa;
}