package com.huigou.topsun.sap.fixedAssets.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * SAP固定资产转移
 *
 * @TableName sap_fixed_assets_move
 */
@Table(name = "sap_fixed_assets_move")
@Entity
@Data
public class SapFixedAssetsMove extends FlowBillAbstractEntity {
    /**
     * 联系方式
     */
    @Column(name = "tel")
    private String tel;

    /**
     * 原因
     */
    @Column(name = "reason")
    private String reason;


    @Override
    protected String getCodeRuleId() {
        return "sapFixedAssetsMove";
    }
}