package com.huigou.topsun.sap.fixedAssets.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * SAP在建工程核算及转固
 *
 * @TableName sap_fixed_assess_item
 */
@Table(name = "sap_fixed_assess_item")
@Entity
@Data
public class SapFixedAssessItem extends AbstractEntity {
    /**
     * SAPv
     */
    @Column(name = "sap_fixed_assess_id")
    private String sapFixedAssessId;

    /**
     * 公司代码（必填）
     */
    @Column(name = "bukrs")
    private String bukrs;


    /**
     * 主资产号
     */
    @Column(name = "anln1")
    private String anln1;

    /**
     * 子资产号
     */
    @Column(name = "anln2")
    private String anln2;

    /**
     * 凭证日期
     */
    @Column(name = "bldat")
    private Date bldat;

    /**
     * 过账日期
     */
    @Column(name = "BUDAT")
    private Date budat;

    /**
     * 资产起息日
     */
    @Column(name = "BZDAT")
    private Date bzdat;

    /**
     * 文本
     */
    @Column(name = "SGTXT")
    private String sgtxt;


    /**
     * 接收方
     */
    @Column(name = "empge")
    private String empge;



    /**
     * 百分比
     */
    @Column(name = "PROZS")
    private BigDecimal prozs;

    /**
     * 金额
     */
    @Column(name = "betrr")
    private BigDecimal betrr;

}