package com.huigou.topsun.sap.fixedAssets.controller;

import com.huigou.topsun.sap.fixedAssets.application.SapFixedAssetsMoveItemApplication;
import com.huigou.topsun.sap.fixedAssets.application.SapFixedRetirementItemApplication;
import com.huigou.topsun.sap.fixedAssets.domain.query.SapFixedAssetsMoveQueryRequest;
import com.huigou.topsun.sap.fixedAssets.domain.query.SapFixedRetirementQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date: 2024/03/09/10:34
 * @Description:
 */
@Controller
@ControllerMapping("/sapFixedRetirementItem")
public class SapFixedRetirementItemController extends CommonController {
    @Autowired
    private SapFixedRetirementItemApplication sapFixedRetirementItemApplication;

    public String querySapFixedRetirementItems(){
        SDO sdo = this.getSDO();
        SapFixedRetirementQueryRequest queryRequest = sdo.toQueryRequest(SapFixedRetirementQueryRequest.class);
        Map<String, Object> map = sapFixedRetirementItemApplication.querySapFixedRetirementItems(queryRequest);
        return toResult(map);
    }

    public String deleteSapFixedRetirementItems(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        sapFixedRetirementItemApplication.deleteByIds(ids);
        return success();
    }
}
