package com.huigou.topsun.sap.fixedAssets.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.demo.application.LeaveApplication;
import com.huigou.topsun.demo.domain.model.Leave;
import com.huigou.topsun.sap.fixedAssets.application.SapFixedAssetsApplication;
import com.huigou.topsun.sap.fixedAssets.domain.SapFixedAssets;
import com.huigou.topsun.sap.fixedAssets.domain.query.SapFixedAssetsQueryRequest;
import com.huigou.topsun.sap.fixedAssets.domain.vo.SapFixedAssetsVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;

/**
 * @Auther: xin.lu
 * @Date: 2023/12/21/9:44
 * @Description:
 */
@Controller
@ControllerMapping("/sapFixedAssets")
public class SapFixedAssetsController extends CommonController {

    @Autowired
    private SapFixedAssetsApplication sapFixedAssetsApplication;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/fixedAssets/";
    }

    /**
     * 跳转到固定资产展示页面
     */
    public String forwardSapFixedAssetsList() {
        return forward("sapFixedAssetsList");
    }

    /**
     * 查询固定资产列表
     */
    public String slicedFixedAssetsList() {
        SDO sdo = this.getSDO();
        SapFixedAssetsQueryRequest sapFixedAssetsQueryRequest = sdo.toQueryRequest(SapFixedAssetsQueryRequest.class);
        return toResult(sapFixedAssetsApplication.getFixedAssetsList(sapFixedAssetsQueryRequest));
    }

    /**
     * 跳转到新增固定资产页面
     */
    public String addFixedAssetsDetail() {
        this.putAttribute("processDefinitionKey", sapFixedAssetsApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        SapFixedAssets sapFixedAssets = new SapFixedAssets();
        sapFixedAssets.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        sapFixedAssets.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("sapFixedAssetsDetail",sapFixedAssets);
    }

    /**
     * 跳转到增固定资产页面
     */
    public String showFixedAssets() {
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        SapFixedAssetsVo sapFixedAssetsVo = sapFixedAssetsApplication.getFixedAssetsById(id);
        return forward("sapFixedAssetsDetail", sapFixedAssetsVo);
    }

    /**
     * 根据id获取固定资产信息
     */
    public String showFixedAssetsDetail() {
        String id = this.getSDO().getString("id");
        SapFixedAssetsVo sapFixedAssetsVo = sapFixedAssetsApplication.getFixedAssetsById(id);
        return forward("sapFixedAssetsDetail",sapFixedAssetsVo);
    }

    /**
     * 删除固定资产
     */
    public String deleteCostCenterById() {
        List<String> ids = this.getSDO().getIds();
        sapFixedAssetsApplication.deleteByIds(ids);
        return success();
    }

    /**
     * 新增固定资产信息
     */
    public String saveFixedAssets() {
        SDO sdo = this.getSDO();
        SapFixedAssetsVo sapFixedAssetsVo = sdo.toObject(SapFixedAssetsVo.class);
        SapFixedAssets sapFixedAssets = SapFixedAssetsVo.getSapFixedAssets(sapFixedAssetsVo);
        // TODO
        // 判断是修改还是新增
        Operator operator = sdo.getOperator();
        sapFixedAssetsVo = sapFixedAssetsApplication.saveAndUpdate(sapFixedAssets,operator);


        return success(sapFixedAssetsVo);
    }
}
