package com.huigou.topsun.sap.fixedAssets.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.fixedAssets.application.SapFixedAssessItemApplication;
import com.huigou.topsun.sap.fixedAssets.application.SapFixedRetirementItemApplication;
import com.huigou.topsun.sap.fixedAssets.domain.SapFixedAssessItem;
import com.huigou.topsun.sap.fixedAssets.domain.SapRetirementItem;
import com.huigou.topsun.sap.fixedAssets.domain.query.SapFixedAssessQueryRequest;
import com.huigou.topsun.sap.fixedAssets.domain.query.SapFixedRetirementQueryRequest;
import com.huigou.topsun.sap.fixedAssets.repository.SapFixedAssessItemRepository;
import com.huigou.topsun.sap.fixedAssets.repository.SapFixedRetirementItemRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date: 2024/03/11/15:16
 * @Description:
 */
@Service("sapFixedAssessItemApplication")
public class SapFixedAssessItemApplicationImpl extends BaseApplication implements SapFixedAssessItemApplication {
    @Autowired
    private SapFixedAssessItemRepository sapFixedAssessItemRepository;
    @Override
    public void saveSapFixedAssessItems(String sapFixedAssessId, List<SapFixedAssessItem> items) {
        for (SapFixedAssessItem item : items) {
            item.setSapFixedAssessId(sapFixedAssessId);
            sapFixedAssessItemRepository.save(item);
        }
    }

    @Override
    public Map<String, Object> querySapFixedAssessItems(SapFixedAssessQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getSapFixedAssessId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "sapFixedAssessItems");

            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            if (queryRequest.getSapFixedAssessId() != null) {
                queryModel.addCriteria(" and t.sap_fixed_assess_id =:sapFixedAssessId");
                queryModel.putParam("sapFixedAssessId", queryRequest.getSapFixedAssessId());
            }
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            sapFixedAssessItemRepository.delete(id);
        });
    }

    @Override
    public List<SapFixedAssessItem> findBySapFixedAssessId(String sapRetirementId) {
        return sapFixedAssessItemRepository.findBySapFixedAssessId(sapRetirementId);
    }
}
