package com.huigou.topsun.sap.finaCustomer.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * 财务客户主数据
  */
@Table(name="sap_fina_customer_info")
@Data
@Entity
public class FinaCustomerInfo extends FlowBillAbstractEntity {

    /**
     * 业务伙伴编码
     */
    @Column(name = "bu_partner")
    @JsonProperty("BU_PARTNER")
    private String buPartner;

    /**
     * 业务伙伴分组
     */
    @Column(name = "creation_group")
    @JsonProperty("CREATION_GROUP")
    private String creationGroup;

    /**
     * 业务伙伴角色
     */
    @Column(name = "partner_role")
    @JsonProperty("PARTNER_ROLE")
    private String partnerRole;

    /**
     * 称谓代码
     * 非必填，设下拉菜单，选项为【0001女士】、【0002先生】、【0003公司】
     */
    @Column(name = "title_medi")
    @JsonProperty("TITLE_MEDI")
    private String titleMedi;

    /**
     * 组织名称 1
     */
    @Column(name = "name_org1")
    @JsonProperty("NAME_ORG1")
    private String nameOrg1;


    /**
     * 搜索词1
     */
    @Column(name = "bu_sort1_txt")
    @JsonProperty("BU_SORT1_TXT")
    private String buSort1Txt;

    /**
     * 备注
     */
    @Column(name = "zbz01")
    @JsonProperty("zbz01")
    private String zbz01;


    /**
     * 国家/地区代码
     */
    @Column(name = "country")
    @JsonProperty("COUNTRY")
    private String country;

    /**
     * 国家/地区代码
     */
    @Column(name = "country_name")
    private String countryName;

    /**
     * 地区代码
     */
    @Column(name = "region")
    @JsonProperty("REGION")
    private String region;

    /**
     * 地区代码
     */
    @Column(name = "region_name")
    private String regionName;

    /**
     * 街道
     */
    @Column(name = "street")
    @JsonProperty("STREET")
    private String street;

    /**
     * 城市邮政编码
     */
    @Column(name = "post_code1")
    @JsonProperty("POST_CODE1")
    private String postCode1;



    /**
     * 语言关键字
     */
    @Column(name = "langu")
    @JsonProperty("LANGU")
    private String langu;


    /**
     * 电话号码
     */
    @Column(name = "tel_number")
    @JsonProperty("TEL_NUMBER")
    private String telNumber;

    /**
     * 移动电话号码
     */
    @Column(name = "mob_number")
    @JsonProperty("MOB_NUMBER")
    private String mobNumber;

    /**
     * 传真号
     */
    @Column(name = "fax_number")
    @JsonProperty("FAX_NUMBER")
    private String faxNumber;

    /**
     * 电子邮件地址
     */
    @Column(name = "smtp_addr")
    @JsonProperty("SMTP_ADDR")
    private String smtpAddr;

    /**
     * 税号
     */
    @JsonProperty("STENR")
    @Column(name = "stenr")
    private String stenr;

    /**
     * 税号类比
     */
    @Column(name = "tax_type")
    private String taxType;

    /**
     * 税号类比
     */
    @Column(name = "tax_type_name")
    private String taxTypeName;

    /**
     * 中心记帐冻结
     */
    @JsonProperty("SPERR")
    @Column(name = "sperr")
    private String sperr;

    /**
     * 更新标识 I、U、D
     */
    @Column(name = "updkz")
    @JsonProperty("UPDKZ")
    private String updkz;

    //申请类型  -1 删除  0 申请  1 修改
    @Column(name = "apply_type")
    private String applyType;

    /**
     * 供应商编号
     */
    @Column(name = "lifnr")
    private String lifnr;

    @Override
    protected String getCodeRuleId() {
        return "finaCustomerInfo";
    }
}