package com.huigou.topsun.sap.exceptionReport.domain;

import com.huigou.data.domain.model.AbstractEntity;
import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/20/16:37
 * @Description: 品质异常报告责任人
 */
@Data
@Entity
@Table(name = "sap_exception_duty_person")
public class ExceptionReportDutyPerson extends AbstractEntity {

    /**
     * 品质异常报告id
     */
    @Column(name = "exception_report_id")
    private String exceptionReportId;

    /**
     * 工号/供应商编码/客户名编码
     */
    @Column(name = "person_no")
    private String personNo;

    /**
     * 姓名/供应商名称/客户名
     */
    @Column(name = "person_name")
    private String personName;

    /**
     * 部门名称
     */
    @Column(name = "dept_name")
    private String deptName;

    /**
     * 定责比例
     */
    @Column(name = "duty_rate")
    private BigDecimal dutyRate;

    /**
     * 个人责任比例
     */
    @Column(name = "person_duty_rate")
    private BigDecimal personDutyRate;

    /**
     * 责任金额
     */
    @Column(name = "duty_money")
    private BigDecimal dutyMoney;

    /**
     * 备注
     */
    @Column(name = "duty_remark")
    private String dutyRemark;

}
