package com.huigou.topsun.sap.exceptionReport.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: lxh
 * @Date: 2024/08/21/15:05
 * @Description: 品质异常报告供应商 现金、转账处理方式
 */
@Data
@Entity
@Table(name = "sap_exception_report_cash")
public class ExceptionReportCash extends AbstractEntity {

    /**
     * 品质异常报告id
     */
    @Column(name = "exception_report_id")
    private String exceptionReportId;

    /**
     * 付款方式
     */
    @Column(name = "payment")
    private String payment;

    /**
     * 金额
     */
    @Column(name = "money")
    private BigDecimal money;


    /**
     * 币别
     */
    @Column(name = "currency")
    private String currency;


    /**
     * 币别描述
     */
    @Column(name = "currency_name")
    private String currencyName;

    /**
     * 账期
     */
    @Column(name = "period")
    private String period;


    /*
     *备注
     */
    @Column(name = "remark")
    private String remark;
}
