package com.huigou.topsun.sap.exceptionReport.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/20/16:37
 * @Description: 品质异常报告
 */
@Data
@Entity
@Table(name = "sap_exception_report")
public class ExceptionReport extends FlowBillAbstractEntity {

    /**
     * 异常类型
     */
    @Column(name = "exception_type")
    private String exceptionType;

    /**
     * 呈报日期
     */
    @Column(name = "report_date")
    private Date reportDate;

    /**
     * 客户名称/供应商名称
     */
    @Column(name = "customer_name")
    private String customerName;

    @Transient
    private String customerNamePur;

    @Column(name = "customer_no")
    private String customerNo;

    @Transient
    private String customerNoPur;

    @Column(name = "werks")
    private String werks;

    @Column(name = "werks_name")
    private String werksName;

    /**
     * 客户单号
     */
    @Column(name = "customer_order_no")
    private String customerOrderNo;

    @Transient
    private String customerOrderNoPur;
    /**
     * 异常陈诉
     */
    @Column(name = "exception_state")
    private String exceptionState;

    /**
     * 异常原因
     */
    @Column(name = "exception_reason")
    private String exceptionReason;

    /**
     * 改善措施
     */
    @Column(name = "deal_method")
    private String dealMethod;

    /**
     * 责任部门
     */
    @Column(name = "duty_dept")
    private String dutyDept;

    /**
     * 责任部门名称
     */
    @Column(name = "duty_dept_name")
    private String dutyDeptName;

    /**
     * 责任人
     */
    @Column(name = "check_operator")
    private String checkOperator;

    /**
     * 责任人名称
     */
    @Column(name = "check_operator_name")
    private String checkOperatorName;

    /**
     * 处理结果
     */
    @Column(name = "deal_result")
    private String dealResult;

    /**
     * 供应商的处理方式
     */
    @Column(name = "deal_way")
    private String dealWay;

    /**
     * 单位主管
     */
    @Column(name = "manager")
    private String manager;

    /**
     * 副理
     */
    @Column(name = "deputy_manager")
    private String deputyManager;

    /**
     * 经理
     */
    @Column(name = "general_manager")
    private String generalManager;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;


    //@Transient
    @Column(name = "attbiz_id")
    private String attbizId;

    @Column(name = "pay_money")
    private BigDecimal payMoney;


    @Column(name = "lose_money")
    private BigDecimal loseMoney;

    //单据类型
    @Column(name = "bill_type")
    private String billType;


    //SAP单据编号
    @Column(name = "sap_bill_no")
    private String sapBillNo;

    //材料编码
    @Column(name = "matnr")
    private String matnr;
    //材料名称
    @Column(name = "maktx")
    private String maktx;


    @Column(name = "exception_title")
    private String exceptionTitle;

    @Column(name = "exception_reason_type")
    private String exceptionReasonType;

    @Column(name = "appeal_no")
    private String appealNo;

    //紧急程度
    @Column(name = "urgency")
    private String urgency;

    @Column(name = "exception_date")
    private Date exceptionDate;

    @Column(name = "problem_times")
    private Integer problemTimes;

    @Column(name = "brand_name")
    private String brandName;

    @Column(name = "need_improve_report")
    private String needImproveReport;

    @Column(name = "need_guarantee")
    private String needGuarantee;

    @Column(name = "handle_node_name")
    private String handleNodeName;

    @Column(name = "handle_node_id")
    private String handleNodeId;

    @Column(name = "product_type")
    private String productType;

    @Column(name = "product_type_name")
    private String productTypeName;

    @Column(name = "source_bill_code")
    private String sourceBillCode;

    @Column(name = "produce_no")
    private String produceNo;

    @Column(name = "reason_type_name")
    private String reasonTypeName;

    @Column(name = "reason_type_detail")
    private String reasonTypeDetail;

    @Column(name = "reason_type_detail_name")
    private String reasonTypeDetailName;

     @Override
    protected String getCodeRuleId() {
        return "exceptionReport";
    }
}
