package com.huigou.topsun.sap.exceptionReport.controller;

import com.huigou.topsun.sap.exceptionReport.application.ExceptionReasonTypeDetailApplication;
import com.huigou.topsun.sap.exceptionReport.domain.ExceptionReasonTypeDetail;
import com.huigou.topsun.sap.exceptionReport.domain.query.ExceptionReasonTypeDetailQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;
import java.util.Map;

/**
 * @author xin.lu
 * @Description: TODO
 * @date 2025/2/1116:01
 */
@Controller
@ControllerMapping("/exceptionReasonTypeDetail")
public class ExceptionReasonTypeDetailController extends CommonController {
    @Autowired
    private ExceptionReasonTypeDetailApplication exceptionReasonTypeDetailApplication;
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/exceptionReport/";
    }

    /**
     * 跳转到异常原因分类明细查询页面
     * @return
     */
    public String forwardExceptionReasonTypeDetailList(){
        return forward("exceptionReasonTypeDetailList");
    }

    /**
     * 条件查询异常原因分类明细
     * @return
     */
    public String slicedExceptionReasonTypeDetailList(){
        SDO sdo = this.getSDO();
        ExceptionReasonTypeDetailQueryRequest queryRequest = sdo.toQueryRequest(ExceptionReasonTypeDetailQueryRequest.class);
        Map<String, Object> map = exceptionReasonTypeDetailApplication.getReasonTypeDetailMap(queryRequest);
        return toResult(map);
    }

    public String showInsertExceptionReasonTypeDetail(){
        return forward("insertExceptionReasonTypeDetail");
    }

    /**
     * 保存异常原因分类明细
     * @return
     */
    public String savedExceptionReasonTypeDetail(){
        SDO sdo = this.getSDO();
        ExceptionReasonTypeDetail exceptionReasonTypeDetail = sdo.toObject( ExceptionReasonTypeDetail.class);
        return toResult(exceptionReasonTypeDetailApplication.save(exceptionReasonTypeDetail));
    }

    public String showUpdateExceptionReasonTypeDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
        ExceptionReasonTypeDetail exceptionReasonTypeDetail = exceptionReasonTypeDetailApplication.load(id);
        return forward("insertExceptionReasonTypeDetail",exceptionReasonTypeDetail);
    }

    /**
     * 批量删除
     * @return
     */
    public String deleteExceptionReasonTypeDetail(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        exceptionReasonTypeDetailApplication.deleteByIds(ids);
        return success();
    }
}
