package com.huigou.topsun.sap.exceptionReport.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.exceptionReport.application.ExceptionReportCashApplication;
import com.huigou.topsun.sap.exceptionReport.application.ExceptionReportPayableApplication;
import com.huigou.topsun.sap.exceptionReport.domain.ExceptionReportCash;
import com.huigou.topsun.sap.exceptionReport.domain.ExceptionReportPayable;
import com.huigou.topsun.sap.exceptionReport.domain.query.ExceptionReportQueryRequest;
import com.huigou.topsun.sap.exceptionReport.repository.ExceptionReportCashRepository;
import com.huigou.topsun.sap.exceptionReport.repository.ExceptionReportPayableRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: lxh
 * @Date: 2024/08/21/19:36
 * @Description: 品质异常报告扣除应付款处理方式信息
 */
@Service("exceptionReportPayableApplication")
public class ExceptionReportPayableApplicationImpl extends BaseApplication implements ExceptionReportPayableApplication {
    @Autowired
    private ExceptionReportPayableRepository exceptionReportPayableRepository;
    @Override
    public List<ExceptionReportPayable> findByExceptionReportId(String exceptionReportId) {
        return exceptionReportPayableRepository.findByExceptionReportId(exceptionReportId);
    }

    @Override
    public void saveExceptionReportPayableList(String exceptionReportId, List<ExceptionReportPayable> payableList) {
        for (ExceptionReportPayable exceptionReportPayable : payableList) {
            exceptionReportPayable.setExceptionReportId(exceptionReportId);
            exceptionReportPayableRepository.save(exceptionReportPayable);
        }
    }

    @Override
    public Map<String, Object> slicedExceptionReportPayableList(ExceptionReportQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getExceptionReportId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "exceptionReportPayable");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        for (String id : ids) {
            exceptionReportPayableRepository.delete(id);
        }
    }

    @Override
    public void saveExceptionReportPayable(ExceptionReportPayable exceptionReportPayable) {
        exceptionReportPayableRepository.save(exceptionReportPayable);
    }
}
