package com.huigou.topsun.sap.exceptionReport.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.exceptionReport.application.ExceptionReportItemApplication;
import com.huigou.topsun.sap.exceptionReport.domain.ExceptionReportItem;
import com.huigou.topsun.sap.exceptionReport.domain.query.ExceptionReportQueryRequest;
import com.huigou.topsun.sap.exceptionReport.repository.ExceptionReportItemRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/20/19:36
 * @Description: 品质异常报告订单信息
 */
@Service("exceptionReportItemApplication")
public class ExceptionReportItemApplicationImpl extends BaseApplication implements ExceptionReportItemApplication {
    @Autowired
    private ExceptionReportItemRepository exceptionReportItemRepository;
    @Override
    public List<ExceptionReportItem> findByExceptionReportId(String exceptionReportId) {
        return exceptionReportItemRepository.findByExceptionReportId(exceptionReportId);
    }

    @Override
    public void saveExceptionReportItemList(String exceptionReportId,String reasonType, List<ExceptionReportItem> exceptionReportItems) {
        for (ExceptionReportItem exceptionReportItem : exceptionReportItems) {
            exceptionReportItem.setExceptionReportId(exceptionReportId);
            if ("3".equals(reasonType)){
                reasonType="2";
            }
            exceptionReportItem.setReasonType(reasonType);
            exceptionReportItemRepository.save(exceptionReportItem);
        }
    }

    @Override
    public Map<String, Object> slicedExceptionReportItemList(ExceptionReportQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getExceptionReportId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "exceptionReportItems");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        for (String id : ids) {
            exceptionReportItemRepository.delete(id);
        }
    }

    @Override
    public void saveExceptionReportItem(ExceptionReportItem exceptionReportItem) {
        exceptionReportItemRepository.save(exceptionReportItem);
    }
}
