package com.huigou.topsun.sap.exceptionReport.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.exceptionReport.application.ExceptionReasonTypeDetailApplication;
import com.huigou.topsun.sap.exceptionReport.domain.ExceptionReasonTypeDetail;
import com.huigou.topsun.sap.exceptionReport.domain.query.ExceptionReasonTypeDetailQueryRequest;
import com.huigou.topsun.sap.exceptionReport.repository.ExceptionReasonTypeDetailRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author xin.lu
 * @Description: TODO
 * @date 2025/2/1115:25
 */
@Service("exceptionReasonTypeDetailApplication")
public class ExceptionReasonTypeDetailApplicationImpl extends BaseApplication implements ExceptionReasonTypeDetailApplication {
    @Autowired
    private ExceptionReasonTypeDetailRepository exceptionReasonTypeDetailRepository;
    @Override
    public ExceptionReasonTypeDetail save(ExceptionReasonTypeDetail exceptionReasonTypeDetail) {
        return exceptionReasonTypeDetailRepository.save(exceptionReasonTypeDetail);
    }

    @Override
    public void delete(String id) {
        exceptionReasonTypeDetailRepository.delete(id);
    }

    @Override
    public Map<String, Object> getReasonTypeDetailMap(ExceptionReasonTypeDetailQueryRequest queryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "exceptionReasonTypeDetail");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
        return this.sqlExecutorDao.executeSlicedQuery(queryModel);
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(this::delete);
    }

    @Override
    public ExceptionReasonTypeDetail load(String id) {
        return exceptionReasonTypeDetailRepository.findOne(id);
    }

    @Override
    public List<Map<String, Object>> getReasonTypeDetailListMap(String param) {
        if (StringUtil.isNotBlank(param)){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "exceptionReasonTypeDetailListByCondition");
            String sql = queryDescriptor.getSql();
            return this.sqlExecutorDao.queryToListMap(sql, param, param, param);
        }else {
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "exceptionReasonTypeDetailListNoCondition");
            String sql = queryDescriptor.getSql();
            return this.sqlExecutorDao.queryToListMap(sql);
        }
    }

}
