package com.huigou.topsun.sap.dull.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;

import com.huigou.topsun.sap.dull.application.SapDullApplication;
import com.huigou.topsun.sap.dull.domain.SapDull;
import com.huigou.topsun.sap.dull.domain.query.SapDullQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.tool.dataimport.application.ExcelImportApplication;
import com.huigou.util.CommonUtil;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date: 2024/03/28 20:10
 * @Description:
 */
@Controller
@ControllerMapping("/sapDull")
public class SapDullController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/dull/";
    }

    @Resource
    private SapDullApplication sapDullApplication;



    public String forwardSapDullList(){
        return forward("sapDullList");
    }

    public String slicedSapDullList(){
        SDO sdo = this.getSDO();
        SapDullQueryRequest queryRequest = sdo.toQueryRequest(SapDullQueryRequest.class);
        Map<String, Object> map = sapDullApplication.getDullList(queryRequest);
        return toResult(map);
    }

    public String forwardSapDullDetail(){
        this.putAttribute("processDefinitionKey", SapDullApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        SapDull sapDull = new SapDull();
        sapDull.setStatusId(BizBillStatus.APPLYING.getId());
        sapDull.setAttbizId(CommonUtil.createGUID()); // 自动生成附件id
        sapDull.setIsFinished("0");
        Operator operator = getOperator();
        sapDull.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
       // ExcelImportTemplate excelImportTemplate=excelImportApplication.loadExcelImportTemplateByCode("sapDullData");
        return forward("sapDullDetail",sapDull);
    }

    public String showDull(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        SapDull sapDull = sapDullApplication.getDullById(id);
        return forward("sapDullDetail",sapDull);
    }

    /**
     * 删除呆滞物料
     */
    public String deleteSapDull() {
        List<String> ids = this.getSDO().getIds();
        sapDullApplication.deleteByIds(ids);
        return success();
    }

    public String updateStatus(){
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        String status = sdo.getString("status");
        sapDullApplication.updateStatus(id,status);
        return success();
    }

}
