package com.huigou.topsun.sap.customerDelayPay.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @Auther: xin.lu
 * @Date: 2024/04/13/11:40
 * @Description: 客户延期付款申请明细
 */
@Data
public class CustomerDelayPayItemVo implements Serializable {

    /**
     到期日期
     */
    @JsonProperty("NETDT")
    private String netdt;

    /**
     * 延期次数
     */
    @JsonProperty("ZEXTND")
    private String zextnd;

    /**
     * 公司代码
     */
    @JsonProperty("COMP_CODE")
    private String compCode;

    /**
     * 客户编号
     */
    @JsonProperty("CUSTOMER")
    private String customer;

    /**
     * 名称
     */
    @JsonProperty("NAME")
    private String name;

    /**
     * 抬头文本/增值税发票号
     */
    @JsonProperty("BKTXT")
    private String bktxt;
    /**
     * 付款参考 /请款单号
     */
    @JsonProperty("KIDNO")
    private String kidno;

    /**
     * 催款层次
     */
    @JsonProperty("DUNN_LEVEL")
    private String dunnLevel;

    /**
     * 上次催款日期
     */
    @JsonProperty("LAST_DUNN")
    private String lastDunn;

    /**
     * 会计年度
     */
    @JsonProperty("FISC_YEAR")
    private String fiscYear;

    /**
     * 会计期间
     */
    @JsonProperty("FIS_PERIOD")
    private String fisPeriod;

    /**
     * 凭证编号
     */
    @JsonProperty("DOC_NO")
    private String docNo;

    /**
     * 行项目号
     */
    @JsonProperty("ITEM_NUM")
    private String itemNum;

    /**
     * 凭证日期
     */
    @JsonProperty("DOC_DATE")
    private String docDate;

    /**
     * 交易金额
     */
    @JsonProperty("AMT_DOCCUR")
    private String amtDoccur;

    /**
     * 交易货币
     */
    @JsonProperty("CURRENCY")
    private String currency;

    /**
     * 本币金额
     */
    @JsonProperty("LC_AMOUNT")
    private String lcAmount;

    /**
     * 本币
     */
    @JsonProperty("LOC_CURRCY")
    private String locCurrcy;

    /**
     * 项目文本
     */
    @JsonProperty("ITEM_TEXT")
    private String itemText;

    /**
     * 付款条件代码
     */
    @JsonProperty("PMNTTRMS")
    private String pmnttrms;

    /**
     * 起算日期
     */
    @JsonProperty("BLINE_DATE")
    private String blineDate;

    /**
     * 扣单应收项次
     */
    @JsonProperty("XBLOCK")
    private String xblock;

    /**
     * 账期
     */
    @JsonProperty("ZBD1T")
    private String zbd1t;

    /**
     * 到期天数
     */
    @JsonProperty("DSCT_DAYS1")
    private String dsctDays1;

}
