package com.huigou.topsun.sap.customerDelayPay.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huigou.data.domain.model.AbstractEntity;
import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/04/13/11:40
 * @Description: 客户延期付款申请明细
 */
@Table(name = "sap_customer_delay_pay_item")
@Entity
@Data
public class CustomerDelayPayItem extends AbstractEntity {

    @Column(name = "customer_delay_pay_id")
    private String customerDelayPayId;
    /**
     到期日期
     */
    @Column(name = "NETDT")
    private String netdt;

    /**
     * 延期次数
     */
    @Column(name = "ZEXTND")
    private String zextnd;

    /**
     * 公司代码
     */
    @Column(name = "COMP_CODE")
    private String compCode;

    /**
     * 客户编号
     */
    @Column(name = "CUSTOMER")
    private String customer;

    /**
     * 名称
     */
    @Column(name = "NAME")
    private String name;

    /**
     * 抬头文本/增值税发票号
     */
    @Column(name = "BKTXT")
    private String bktxt;
    /**
     * 付款参考 /请款单号
     */
    @Column(name = "KIDNO")
    private String kidno;

    /**
     * 催款层次
     */
    @Column(name = "DUNN_LEVEL")
    private String dunnLevel;

    /**
     * 上次催款日期
     */
    @Column(name = "LAST_DUNN")
    private String lastDunn;

    /**
     * 会计年度
     */
    @Column(name = "FISC_YEAR")
    private String fiscYear;

    /**
     * 会计期间
     */
    @Column(name = "FIS_PERIOD")
    private String fisPeriod;

    /**
     * 凭证编号
     */
    @Column(name = "DOC_NO")
    private String docNo;

    /**
     * 行项目号
     */
    @Column(name = "ITEM_NUM")
    private String itemNum;

    /**
     * 凭证日期
     */
    @Column(name = "DOC_DATE")
    private String docDate;

    /**
     * 交易金额
     */
    @Column(name = "AMT_DOCCUR")
    private String amtDoccur;

    /**
     * 交易货币
     */
    @Column(name = "CURRENCY")
    private String currency;

    /**
     * 本币金额
     */
    @Column(name = "LC_AMOUNT")
    private String lcAmount;

    /**
     * 本币
     */
    @Column(name = "LOC_CURRCY")
    private String locCurrcy;

    /**
     * 项目文本
     */
    @Column(name = "ITEM_TEXT")
    private String itemText;

    /**
     * 付款条件代码
     */
    @Column(name = "PMNTTRMS")
    private String pmnttrms;

    /**
     * 起算日期
     */
    @Column(name = "BLINE_DATE")
    private String blineDate;

    /**
     * 扣单应收项次
     */
    @Column(name = "XBLOCK")
    private String xblock;

    /**
     * 账期
     */
    @Column(name = "ZBD1T")
    private String zbd1t;

    /**
     * 到期天数
     */
    @Column(name = "DSCT_DAYS1")
    private String dsctDays1;

}
