package com.huigou.topsun.sap.customerDelayPay.application.impl;

import com.alibaba.fastjson.JSONObject;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.common.HttpClient;
import com.huigou.topsun.sap.common.domain.SapResult;
import com.huigou.topsun.sap.customerDelayPay.application.CustomerDelayPayItemApplication;
import com.huigou.topsun.sap.customerDelayPay.domain.CustomerDelayPayItem;
import com.huigou.topsun.sap.customerDelayPay.domain.query.CustomerDelayPayQueryRequest;
import com.huigou.topsun.sap.customerDelayPay.domain.query.SapCustomerDelayPayQueryVo;
import com.huigou.topsun.sap.customerDelayPay.repository.CustomerDelayPayItemRepository;
import com.huigou.topsun.sap.customerDelayPay.vo.CustomerDelayPayItemVo;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Auther: xin.lu
 * @Date: 2024/04/13/14:50
 * @Description:
 */
@Service("customerDelayPayItemApplication")
public class CustomerDelayPayItemApplicationImpl extends BaseApplication implements CustomerDelayPayItemApplication {
    @Autowired
    private CustomerDelayPayItemRepository customerDelayPayItemRepository;

    @Autowired
    private HttpClient httpClient;
    @Override
    public void saveCustomerDelayPayItems(String customerDelayPayId, List<CustomerDelayPayItem> customerDelayPayItems) {
        for (CustomerDelayPayItem customerDelayPayItem : customerDelayPayItems) {
            customerDelayPayItem.setCustomerDelayPayId(customerDelayPayId);
            customerDelayPayItemRepository.save(customerDelayPayItem);
        }
    }

    @Override
    public Map<String, Object> queryCustomerDelayPayItems(CustomerDelayPayQueryRequest queryRequest) {
        List<CustomerDelayPayItem> customerDelayPayItems = new ArrayList<>();
        Map<String,Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getCustomerDelayPayId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "customerDelayPayItems");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }else {
            SapCustomerDelayPayQueryVo sapCustomerDelayPayQueryVo = new SapCustomerDelayPayQueryVo();
            BeanUtils.copyProperties(queryRequest, sapCustomerDelayPayQueryVo);
            customerDelayPayItems = this.queryCustomerDelayPayItemsFromSap(sapCustomerDelayPayQueryVo);
            map.put("Rows",customerDelayPayItems);
            map.put("Total",customerDelayPayItems.size());
            map.put("page",1);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        for (String id : ids) {
            customerDelayPayItemRepository.delete(id);
        }
    }

    @Override
    public List<CustomerDelayPayItem> queryCustomerDelayPayItemsFromSap(SapCustomerDelayPayQueryVo queryVo) {
        List<SapCustomerDelayPayQueryVo> queryVoList = new ArrayList<>();
        queryVoList.add(queryVo);
        List<CustomerDelayPayItem> customerDelayPayItemList = new ArrayList<>();
        try {
            String execute = httpClient.execute(queryVoList, "get_ar_due");
            List<SapResult> sapResultList = JSONObject.parseArray(execute, SapResult.class);
            if ("E".equals(sapResultList.get(0).getTYPE())){
                return customerDelayPayItemList;
            }
            List<CustomerDelayPayItemVo> resultList = JSONObject.parseArray(execute, CustomerDelayPayItemVo.class);
            if (!CollectionUtils.isEmpty(resultList)){
                customerDelayPayItemList = resultList
                        .stream()
                        .map(customerDelayPayItemVo -> {
                            CustomerDelayPayItem customerDelayPayItem = new CustomerDelayPayItem();
                            BeanUtils.copyProperties(customerDelayPayItemVo,customerDelayPayItem);
                            return customerDelayPayItem;
                        }).collect(Collectors.toList());
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customerDelayPayItemList;
    }

}
