package com.huigou.topsun.sap.costReimbursement.application.impl;

import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.costReimbursement.application.SapCostReimbursementDetailApplication;
import com.huigou.topsun.sap.costReimbursement.domain.SapCostReimbursementDetail;
import com.huigou.topsun.sap.costReimbursement.domain.query.SapCostReimbursementQueryRequest;
import com.huigou.topsun.sap.costReimbursement.repostiory.SapCostReimbursementDetailRepository;
import com.huigou.topsun.sap.statsIndicators.application.SapStatsIndicatorsDetailApplication;
import com.huigou.topsun.sap.statsIndicators.domain.query.SapStatsIndicatorsDetailQueryRequest;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
public class SapCostReimbursementDetailApplicationImpl extends BaseApplication implements SapCostReimbursementDetailApplication {

    @Override
    public Map<String, Object> slicedSapCostReimbursementDetail(SapCostReimbursementQueryRequest query) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "slicedSapCostReimbursementDetail");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, query);
        queryModel.putDictionary("mwskz", DictUtil.getDictionary("mwskz"));
        queryModel.putDictionary("zlsch", DictUtil.getDictionary("zlsch"));
        queryModel.putDictionary("zyl05", DictUtil.getDictionary("zyl05"));
        return this.sqlExecutorDao.executeQuery(queryModel);
    }
    @Autowired
    SapCostReimbursementDetailRepository costReimbursementDetailRepository;

    @Override
    public List<SapCostReimbursementDetail> getAllByCRId(String CRId) {
        return costReimbursementDetailRepository.findAllByReimbursementBaseInfoId(CRId);
    }

    @Override
    public void deleteSapCostReimbursementDetails(List<String> ids) {
        for (String id : ids) {
            costReimbursementDetailRepository.delete(id);
        }
    }
}
