package com.huigou.topsun.sap.costReimbursement.application;

import com.huigou.topsun.sap.costReimbursement.domain.SapCostReimbursement;
import com.huigou.topsun.sap.costReimbursement.domain.query.SapCostReimbursementQueryRequest;
import com.huigou.topsun.sap.costReimbursement.domain.vo.PaymentReceiptVo;
import com.huigou.topsun.sap.statsIndicators.domain.SapStatsIndicators;
import com.huigou.topsun.sap.statsIndicators.domain.query.SapStatsIndicatorsQueryRequest;

import java.util.List;
import java.util.Map;

public interface SapCostReimbursementApplication {


    String PROCESS_DEFINITION_KEY = "sapCostReimbursementProc";


    String QUERY_XML_FILE_PATH="config/topsun/sap/costReimbursement/costReimbursement.xml";


    SapCostReimbursement loadSapCostReimbursementById(String id);

    Map<String, Object> slicedSapCostReimbursementQuery(SapCostReimbursementQueryRequest query);

    void deleteSapCostReimbursementById(String id);
    void deleteSapCostReimbursementByIds(List<String> ids);

    void sendSapDate( SapCostReimbursement sapCostReimbursement);

    void savePaymentReceiptVo(PaymentReceiptVo paymentReceiptVo);

    void endTask(SapCostReimbursement reimbursement);


    Integer checkzyl06(String zyl06);

    Map<String, Object> queryKostlByPersonCode(String personCode);

    Map<String, Object> slicedAdvancePaymentList(SapCostReimbursementQueryRequest queryRequest);

    List<String> excludeCompletePartnerInvs(String partner);

}