package com.huigou.topsun.sap.componentSupply.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * SAP组件补充发料协议明细
 *
 * @TableName sap_component_supply_item
 */
@Table(name = "sap_component_supply_item")
@Entity
@Data
public class ComponentSupplyItem extends AbstractEntity {
    /**
     * SAP组件补充发料id
     */
    @Column(name = "component_supply_id")
    private String componentSupplyId;

    /**
     * 产品物料
     */
    @Column(name = "product_material")
    private String productMaterial;

    /**
     * 产品物料名称
     */
    @Column(name = "product_material_name")
    private String productMaterialName;


    /**
     * 供给物料
     */
    @Column(name = "supply_material")
    private String supplyMaterial;

    /**
     * 供给物料名称
     */
    @Column(name = "supply_material_name")
    private String supplyMaterialName;

    /**
     * 补发数量
     */
    @Column(name = "quantity")
    private BigDecimal quantity;

    /**
     * 提货方式
     */
    @Column(name = "delivery_method")
    private String deliveryMethod;


    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;


}