package com.huigou.topsun.sap.componentSupply.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Auther: LXH
 * @Date: 2024/06/03/10:45
 * @Description:组件补充发料
 */
@Table(name = "sap_component_supply")
@Entity
@Data
public class ComponentSupply extends FlowBillAbstractEntity {

    /**
     * 责任部门
     */
    @Column(name = "depart")
    private String depart;

    @Column(name = "depart_name")
    private String departName;


    /**
     * 申请人
     */
    @Column(name = "apply_person")
    private String applyPerson;

    @Column(name = "apply_person_name")
    private String applyPersonName;


    /*
     * 供应商
     */
    @Column(name = "suppliers")
    private String suppliers;


    /*
     * 供应商名称
     */
    @Column(name = "suppliers_name")
    private String suppliersName;


    /*
     * 工厂名称
     */
    @Column(name = "werks_name")
    private String werksName;

    /*
     * 工厂
     */
    @Column(name = "werks")
    private String werks;

    @Column(name = "need_date")
    private Date needDate;


    @Column(name = "attbiz_id")
    private String attbizId;

    @Override
    protected String getCodeRuleId() {
        return "componentSupply";
    }
}
